<div>
    <div>
        <div class="row mb-4 g-3">
            <div class="col-lg-6 col-12">
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0">View Payroll Period</h6>
                    </div>
                    <div class="card-body">
                        <div class="row g-2">
                            <div class="col-6">
                                <label class="form-label">Month</label>
                                <select wire:model.live="viewMonth" class="form-select">
                                    @foreach($months as $m)
                                        <option value="{{ $m }}">{{ $m }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Year</label>
                                <select wire:model.live="viewYear" class="form-select">
                                    @for($y = 2020; $y <= date('Y') + 1; $y++)
                                        <option value="{{ $y }}">{{ $y }}</option>
                                    @endfor
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-12">
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0">Actions for {{ $viewMonth }} {{ $viewYear }}</h6>
                    </div>
                    <div class="card-body">
                        <div class="row g-2">
                            <div class="col-12">
                                <label class="form-label">Download Format</label>
                                <select wire:model="downloadFormat" class="form-select">
                                    <option value="csv">CSV</option>
                                    <option value="excel">Excel</option>
                                </select>
                            </div>
                            <div class="col-sm-6">
                                <button wire:click="downloadPayroll" class="btn btn-info w-100">
                                    <i class="fas fa-download me-2"></i>Download
                                </button>
                            </div>
                            <div class="col-sm-6">
                                <button onclick="printPayroll()" class="btn btn-secondary w-100">
                                    <i class="fas fa-print me-2"></i>Print
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-4">
            <div class="col-12">
                <div class="row g-2">
                    <div class="col-lg-6 col-12">
                        <div class="d-flex flex-column flex-sm-row gap-2">

                            <button onclick="confirmGeneratePayroll()" class="btn btn-success flex-fill">
                                <i class="fas fa-calendar me-2"></i>Generate Monthly Payroll
                            </button>
                            <button onclick="confirmResetPayroll()" class="btn btn-warning flex-fill">
                                <i class="fas fa-undo me-2"></i>Reset Payroll
                            </button>
                        </div>
                    </div>
                    <div class="col-lg-6 col-12">
                        <input type="text" wire:model.live="search" class="form-control" placeholder="Search staff...">
                    </div>
                </div>
            </div>
        </div>



        @if($salaryHistories->count() > 0)
            <div class="card">
                <div class="card-header">
                    <h5>Salary History - {{ $viewMonth }} {{ $viewYear }}</h5>
                </div>
                <div class="card-body">
                    <!-- Mobile: Accordion view -->
                    <div class="d-lg-none">
                        @foreach($salaryHistories as $salary)
                            <div class="card mb-3">
                                <div class="card-body p-3">
                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                        <h6 class="mb-0">{{ $salary->user->name }}</h6>
                                        <span
                                            class="badge bg-{{ $salary->status === 'paid' ? 'success' : ($salary->status === 'refunded' ? 'info' : ($salary->status === 'cancelled' ? 'danger' : 'warning')) }}">
                                {{ ucfirst($salary->status) }}
                            </span>
                                    </div>
                                    <p class="text-muted mb-2">{{ $salary->month_year }}</p>

                                    <div class="row g-2 mb-3">
                                        <div class="col-6">
                                            <small class="text-muted d-block">Base Salary</small>
                                            <strong>₦{{ number_format($salary->monthly_salary, 0) }}</strong>
                                        </div>
                                        <div class="col-6">
                                            <small class="text-muted d-block">Net Salary</small>
                                            <strong
                                                class="text-success">₦{{ number_format($salary->net_salary, 0) }}</strong>
                                        </div>
                                    </div>

                                    @if($salary->total_bonus > 0 || $salary->total_deductions > 0)
                                        <div class="row g-2 mb-3">
                                            @if($salary->total_bonus > 0)
                                                <div class="col-6">
                                                    <small class="text-muted d-block">Total Bonus</small>
                                                    <span
                                                        class="text-success">₦{{ number_format($salary->total_bonus, 0) }}</span>
                                                </div>
                                            @endif
                                            @if($salary->total_deductions > 0)
                                                <div class="col-6">
                                                    <small class="text-muted d-block">Total Deductions</small>
                                                    <span
                                                        class="text-danger">₦{{ number_format($salary->total_deductions, 0) }}</span>
                                                </div>
                                            @endif
                                        </div>
                                    @endif

                                    @if($salary->adjustments->count() > 0)
                                        <button onclick="showAdjustments({{ $salary->id }})"
                                                class="btn btn-sm btn-outline-info w-100 mb-2">
                                            <i class="fas fa-list me-2"></i>View Adjustments
                                            ({{ $salary->adjustments->count() }})
                                        </button>
                                    @endif

                                    <div class="d-flex flex-wrap gap-2 mb-2">
                                        @if($salary->adjustments->count() > 0)
                                            <button onclick="showAdjustments({{ $salary->id }})"
                                                    class="btn btn-sm btn-outline-info">
                                                <i class="fas fa-list me-1"></i>Adjustments
                                            </button>
                                        @endif
                                        @if($salary->status !== 'paid')
                                            <button type="button" onclick="openAdjustmentModal({{ $salary->id }})"
                                                    class="btn btn-sm btn-primary">
                                                <i class="fas fa-plus me-1"></i>Add
                                            </button>
                                        @endif
                                        @if($salary->status === 'pending' || $salary->status === 'refunded')
                                            <button onclick="confirmMarkPaid({{ $salary->id }})"
                                                    class="btn btn-sm btn-success">
                                                <i class="fas fa-check me-1"></i>Mark Paid
                                            </button>
                                        @elseif($salary->status === 'paid')
                                            <button onclick="confirmMarkRefunded({{ $salary->id }})"
                                                    class="btn btn-sm btn-danger">
                                                <i class="fas fa-undo me-1"></i>Refund
                                            </button>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <!-- Desktop: Table view -->
                    <div class="d-none d-lg-block">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                <tr>
                                    <th>Staff</th>
                                    <th>Period</th>
                                    <th>Base Salary</th>
                                    <th>Total Bonus</th>
                                    <th>Total Deductions</th>
                                    <th>Net Salary</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($salaryHistories as $salary)
                                    <tr>
                                        <td>{{ $salary->user->name }}</td>
                                        <td>{{ $salary->month_year }}</td>
                                        <td>₦{{ number_format($salary->monthly_salary, 0) }}</td>
                                        <td>₦{{ number_format($salary->total_bonus, 0) }}</td>
                                        <td>₦{{ number_format($salary->total_deductions, 0) }}</td>
                                        <td>₦{{ number_format($salary->net_salary, 0) }}</td>
                                        <td>
                                    <span
                                        class="badge bg-{{ $salary->status === 'paid' ? 'success' : ($salary->status === 'refunded' ? 'info' : ($salary->status === 'cancelled' ? 'danger' : 'warning')) }}">
                                        {{ ucfirst($salary->status) }}
                                    </span>
                                        </td>
                                        <td>
                                            <div class="d-flex flex-wrap gap-1">
                                                @if($salary->adjustments->count() > 0)
                                                    <button onclick="showAdjustments({{ $salary->id }})"
                                                            class="btn btn-sm btn-outline-info">
                                                        <i class="fas fa-list me-1"></i>Adjustments
                                                    </button>
                                                @endif
                                                @if($salary->status !== 'paid')
                                                    <button type="button"
                                                            onclick="openAdjustmentModal({{ $salary->id }})"
                                                            class="btn btn-sm btn-primary">
                                                        <i class="fas fa-plus me-1"></i>Add
                                                    </button>
                                                @endif
                                                @if($salary->status === 'pending' || $salary->status === 'refunded')
                                                    <button onclick="confirmMarkPaid({{ $salary->id }})"
                                                            class="btn btn-sm btn-success">
                                                        <i class="fas fa-check me-1"></i>Mark Paid
                                                    </button>
                                                @elseif($salary->status === 'paid')
                                                    <button onclick="confirmMarkRefunded({{ $salary->id }})"
                                                            class="btn btn-sm btn-danger">
                                                        <i class="fas fa-undo me-1"></i>Refund
                                                    </button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>

                    {{ $salaryHistories->links('custom.pagination') }}
                </div>
            </div>
        @else
            <div class="card">
                <div class="card-body text-center py-5">
                    <i class="fas fa-calendar-times fa-4x text-muted mb-3"></i>
                    <h5 class="text-muted">No Payroll Records Found</h5>
                    <p class="text-muted mb-4">There are no salary records for {{ $viewMonth }} {{ $viewYear }}.</p>
                    <button onclick="confirmGeneratePayroll()" class="btn btn-primary">
                        <i class="fas fa-plus me-2"></i>Generate Payroll for {{ $viewMonth }} {{ $viewYear }}
                    </button>
                </div>
            </div>
        @endif
    </div>

    <!-- Adjustment Form Modal -->
    <div class="modal fade" id="adjustmentModal" tabindex="-1" wire:ignore.self>
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title text-light">Add Salary Adjustment</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form wire:submit.prevent="addAdjustment">
                        <input type="hidden" id="selectedSalaryId" wire:model="selectedSalaryId">
                        <div class="mb-3">
                            <label class="form-label">Type *</label>
                            <select wire:model="adjustmentType" class="form-select" required>
                                <option value="bonus">Bonus</option>
                                <option value="deduction">Deduction</option>
                            </select>
                            @error('adjustmentType')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Amount *</label>
                            <input type="number" wire:model="adjustmentAmount" class="form-control" step="0.01" min="0"
                                   required>
                            @error('adjustmentAmount')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Reason</label>
                            <textarea wire:model="adjustmentReason" class="form-control" rows="3"></textarea>
                            @error('adjustmentReason')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary flex-fill">
                                <i class="fas fa-save me-2"></i>Add Adjustment
                            </button>
                            <button type="button" class="btn btn-secondary flex-fill" data-bs-dismiss="modal">Cancel
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Adjustments List Modal -->
    <div class="modal fade" id="adjustmentsListModal" tabindex="-1" wire:ignore.self>
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title text-light">Salary Adjustments</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="adjustmentsList">
                    <!-- Content will be loaded dynamically -->
                </div>
            </div>
        </div>
    </div>
</div>

<script>

    function confirmGeneratePayroll() {
        Swal.fire({
            title: 'Generate Monthly Payroll?',
            text: 'This will generate payroll for staff who don\'t have records for ' +
            @this.get('viewMonth') + ' ' +
            @this.get('viewYear') + '. Existing records will not be affected.',
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: 'var(--bs-primary)',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, Generate Payroll!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                @this.
                call('generateMonthlyPayroll');
            }
        });
    }

    function confirmResetPayroll() {
        Swal.fire({
            title: 'Reset Payroll Entries?',
            text: 'This will remove all bonuses and deductions from unpaid payroll entries for ' +
            @this.get('viewMonth') + ' ' +
            @this.get('viewYear') + '. Paid entries will not be affected.',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#ffc107',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, Reset Payroll!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                @this.
                call('resetPayroll');
            }
        });
    }

    function confirmMarkRefunded(salaryId) {
        Swal.fire({
            title: 'Mark Salary as Refunded?',
            text: 'This will mark the salary as refunded and reset the paid date.',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc3545',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, Mark as Refunded!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                @this.
                call('markAsRefunded', salaryId);
            }
        });
    }

    function confirmMarkPaid(salaryId) {
        Swal.fire({
            title: 'Mark Salary as Paid?',
            text: 'This will mark the salary as paid and cannot be undone.',
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: 'var(--bs-primary)',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, Mark as Paid!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                @this.
                call('markAsPaid', salaryId);
            }
        });
    }


    function showAdjustments(salaryId) {
        fetch(`/payroll/adjustments/${salaryId}`)
            .then(response => response.text())
            .then(html => {
                document.getElementById('adjustmentsList').innerHTML = html;
                new bootstrap.Modal(document.getElementById('adjustmentsListModal')).show();
            })
            .catch(error => {
                console.error('Error:', error);
                Swal.fire('Error', 'Failed to load adjustments', 'error');
            });
    }

    function openAdjustmentModal(salaryId) {
        document.getElementById('selectedSalaryId').value = salaryId;
        @this.
        set('selectedSalaryId', salaryId);
        @this.
        set('adjustmentType', 'bonus');
        @this.
        set('adjustmentAmount', 0);
        @this.
        set('adjustmentReason', '');

        const modal = new bootstrap.Modal(document.getElementById('adjustmentModal'));
        modal.show();
    }

    function printPayroll() {
        const url = `/payroll/print/${@this.get('viewMonth')}/${@this.get('viewYear')}`;
        window.open(url, 'printWindow', 'width=794,height=1123,scrollbars=yes,resizable=yes');
    }

    // Close modal after successful adjustment
    document.addEventListener('livewire:init', () => {
        Livewire.on('adjustment-added', () => {
            const modal = bootstrap.Modal.getInstance(document.getElementById('adjustmentModal'));
            if (modal) modal.hide();
        });
    });
</script>
