<form wire:submit="save">
    <div class="row">
        <div class="col-md-6 mb-3">
            <label for="name" class="form-label">Session Name <span class="text-danger">*</span></label>
            <input type="text" class="form-control @error('name') is-invalid @enderror"
                   wire:model="name" placeholder="e.g., 1st Term, 2nd Term, ...etc">
            @error('name')
            <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-3 mb-3">
            <label for="start_year" class="form-label">Start Year <span class="text-danger">*</span></label>
            <input type="number" class="form-control @error('start_year') is-invalid @enderror"
                   wire:model="start_year" min="2000" max="2100">
            @error('start_year')
            <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-3 mb-3">
            <label for="end_year" class="form-label">End Year <span class="text-danger">*</span></label>
            <input type="number" class="form-control @error('end_year') is-invalid @enderror"
                   wire:model="end_year" min="2000" max="2100">
            @error('end_year')
            <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>

    <div class="row">
        <div class="col-md-4 mb-3">
            <label for="start_date" class="form-label">Start Date</label>
            <input type="date" class="form-control @error('start_date') is-invalid @enderror"
                   wire:model="start_date">
            @error('start_date')
            <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-4 mb-3">
            <label for="end_date" class="form-label">End Date</label>
            <input type="date" class="form-control @error('end_date') is-invalid @enderror"
                   wire:model="end_date">
            @error('end_date')
            <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-4 mb-3">
            <label for="next_session_start_date" class="form-label">Next Session Starts <span class="text-danger">*</span></label>
            <input type="date" class="form-control @error('next_session_start_date') is-invalid @enderror"
                   wire:model="next_session_start_date">
            @error('next_session_start_date')
            <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>

    <div class="row">
        <div class="col-12 mb-3">
            <label for="description" class="form-label">Description</label>
            <textarea class="form-control @error('description') is-invalid @enderror"
                      wire:model="description" rows="3"
                      placeholder="Optional description for this session"></textarea>
            @error('description')
            <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>

    <div class="card mb-3">
        <div class="card-header">
            <h6 class="mb-0">Assessment Scoring Configuration</h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="ca_max_score" class="form-label">C.A Maximum Score <span class="text-danger">*</span></label>
                    <input type="number" class="form-control @error('ca_max_score') is-invalid @enderror"
                           wire:model.live="ca_max_score" min="0" max="99">
                    @error('ca_max_score')
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6 mb-3">
                    <label for="exam_max_score" class="form-label">Exam Maximum Score <span class="text-danger">*</span></label>
                    <input type="number" class="form-control @error('exam_max_score') is-invalid @enderror"
                           wire:model.live="exam_max_score" min="0" max="99">
                    @error('exam_max_score')
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="ca_pass_mark" class="form-label">C.A Pass Mark <span class="text-danger">*</span></label>
                    <input type="number" class="form-control @error('ca_pass_mark') is-invalid @enderror"
                           wire:model="ca_pass_mark" min="0" max="{{ $ca_max_score }}">
                    @error('ca_pass_mark')
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6 mb-3">
                    <label for="exam_pass_mark" class="form-label">Exam Pass Mark <span class="text-danger">*</span></label>
                    <input type="number" class="form-control @error('exam_pass_mark') is-invalid @enderror"
                           wire:model="exam_pass_mark" min="0" max="{{ $exam_max_score }}">
                    @error('exam_pass_mark')
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="alert alert-info">
                <small>
                    <i class="fas fa-info-circle me-1"></i>
                    Total Score: {{ (int)$ca_max_score + (int)$exam_max_score }}/100
                    @if($ca_max_score + $exam_max_score !== 100)
                        <span class="text-danger">(Must equal 100)</span>
                    @endif
                </small>
            </div>
        </div>
    </div>

    <div class="card mb-3">
        <div class="card-header">
            <h6 class="mb-0">Grading System Configuration</h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-4 mb-3">
                    <label for="grade_a_min" class="form-label">Grade A (Minimum %)</label>
                    <input type="number" class="form-control @error('grade_a_min') is-invalid @enderror"
                           wire:model="grade_a_min" min="0" max="100">
                    @error('grade_a_min')
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-4 mb-3">
                    <label for="grade_b_min" class="form-label">Grade B (Minimum %)</label>
                    <input type="number" class="form-control @error('grade_b_min') is-invalid @enderror"
                           wire:model="grade_b_min" min="0" max="100">
                    @error('grade_b_min')
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-4 mb-3">
                    <label for="grade_c_min" class="form-label">Grade C (Minimum %)</label>
                    <input type="number" class="form-control @error('grade_c_min') is-invalid @enderror"
                           wire:model="grade_c_min" min="0" max="100">
                    @error('grade_c_min')
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="row">
                <div class="col-md-4 mb-3">
                    <label for="grade_d_min" class="form-label">Grade D (Minimum %)</label>
                    <input type="number" class="form-control @error('grade_d_min') is-invalid @enderror"
                           wire:model="grade_d_min" min="0" max="100">
                    @error('grade_d_min')
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-4 mb-3">
                    <label for="grade_e_min" class="form-label">Grade E (Minimum %)</label>
                    <input type="number" class="form-control @error('grade_e_min') is-invalid @enderror"
                           wire:model="grade_e_min" min="0" max="100">
                    @error('grade_e_min')
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-4 mb-3">
                    <label for="grade_f_min" class="form-label">Grade F (Minimum %)</label>
                    <input type="number" class="form-control @error('grade_f_min') is-invalid @enderror"
                           wire:model="grade_f_min" min="0" max="100">
                    @error('grade_f_min')
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="overall_pass_percentage" class="form-label">Overall Pass Percentage <span class="text-danger">*</span></label>
                    <input type="number" class="form-control @error('overall_pass_percentage') is-invalid @enderror"
                           wire:model="overall_pass_percentage" min="1" max="100">
                    <small class="form-text text-muted">Minimum percentage of grand total required to pass overall</small>
                    @error('overall_pass_percentage')
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="alert alert-info">
                <small>
                    <i class="fas fa-info-circle me-1"></i>
                    Grade ranges: A ({{ $grade_a_min }}%-100%), B ({{ $grade_b_min }}-{{ $grade_a_min - 1 }}%), 
                    C ({{ $grade_c_min }}-{{ $grade_b_min - 1 }}%), D ({{ $grade_d_min }}-{{ $grade_c_min - 1 }}%), 
                    E ({{ $grade_e_min }}-{{ $grade_d_min - 1 }}%), F ({{ $grade_f_min }}-{{ $grade_e_min - 1 }}%)
                </small>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12 mb-3">
            <div class="form-check">
                <input type="checkbox" class="form-check-input" wire:model="is_active" id="is_active">
                <label class="form-check-label" for="is_active">
                    Set as Active Session
                </label>
                <small class="form-text text-muted d-block">
                    Only one session can be active at a time. Setting this will deactivate other sessions.
                </small>
            </div>
        </div>
    </div>

    <div class="d-flex justify-content-end gap-2">
        <a href="{{ route('school-sessions.index') }}" class="btn btn-secondary">Cancel</a>
        <button type="submit" class="btn btn-primary">
            {{ $sessionId ? 'Update Session' : 'Create Session' }}
        </button>
    </div>
</form>
