<div>
    @if($sessions->count() > 0)
        <!-- Sessions Accordions -->
        <div>
            @foreach($sessions as $index => $session)
                <div class="card mb-2">
                    <div class="card-header p-0">
                        <div class="d-flex">
                            <div class="flex-grow-1 p-3" data-bs-toggle="collapse"
                                 data-bs-target="#session{{ $session->id }}" style="cursor: pointer;">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <strong>{{ $session->name }}</strong>
                                        <span class="text-muted ms-2">|</span>
                                        <span class="ms-2">{{ $session->start_year }}/{{ $session->end_year }}</span>
                                        @if($session->description)
                                            <span class="text-muted ms-2">|</span>
                                            <small class="text-muted ms-2">{{ Str::limit($session->description, 30) }}</small>
                                        @endif
                                    </div>
                                    <div>
                                        @if($session->is_active)
                                            <span class="badge bg-success">Active</span>
                                        @else
                                            <span class="badge bg-secondary">Inactive</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="p-3 border-start">
                                <div class="dropdown">
                                    <button class="btn btn-sm btn-outline-secondary" type="button"
                                            data-bs-toggle="dropdown">
                                        <i class="fas fa-bars"></i>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-sm">
                                        <li><a class="dropdown-item dropdown-item-sm"
                                               href="{{ route('school-sessions.edit', $session->slug) }}">
                                                <i class="fas fa-edit me-2"></i>Edit
                                            </a></li>
                                        @unless($session->is_active)
                                            <li>
                                                <button class="dropdown-item dropdown-item-sm text-success"
                                                        wire:click="confirmActivateSession({{ $session->id }})">
                                                    <i class="fas fa-check me-2"></i>Activate
                                                </button>
                                            </li>
                                        @endunless
                                        <li>
                                            <hr class="dropdown-divider">
                                        </li>
                                        <li>
                                            <button class="dropdown-item dropdown-item-sm text-danger"
                                                    wire:click="confirmDeleteSession({{ $session->id }})">
                                                <i class="fas fa-trash me-2"></i>Delete
                                            </button>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="collapse" id="session{{ $session->id }}">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <p><strong>Academic Year:</strong> {{ $session->start_year }}/{{ $session->end_year }}</p>
                                    <p><strong>Duration:</strong> 
                                        @if($session->start_date && $session->end_date)
                                            {{ $session->start_date->format('M d, Y') }} - {{ $session->end_date->format('M d, Y') }}
                                        @else
                                            <span class="text-muted">Not set</span>
                                        @endif
                                    </p>
                                    @if($session->description)
                                        <p><strong>Description:</strong> {{ $session->description }}</p>
                                    @endif
                                </div>
                                <div class="col-md-6">
                                    <p><strong>Status:</strong> 
                                        @if($session->is_active)
                                            <span class="badge bg-success">Active</span>
                                        @else
                                            <span class="badge bg-secondary">Inactive</span>
                                        @endif
                                    </p>
                                    <p><strong>Created:</strong> {{ $session->created_at->format('M d, Y') }}</p>
                                </div>
                            </div>
                            
                            <hr>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <h6 class="mb-2">Assessment Scoring</h6>
                                    <p><strong>C.A Max Score:</strong> {{ $session->ca_max_score ?? 40 }}/100</p>
                                    <p><strong>Exam Max Score:</strong> {{ $session->exam_max_score ?? 60 }}/100</p>
                                </div>
                                <div class="col-md-6">
                                    <h6 class="mb-2">Pass Marks</h6>
                                    <p><strong>C.A Pass Mark:</strong> {{ $session->ca_pass_mark ?? 20 }}</p>
                                    <p><strong>Exam Pass Mark:</strong> {{ $session->exam_pass_mark ?? 30 }}</p>
                                    <p><strong>Overall Pass:</strong> {{ $session->overall_pass_percentage ?? 50 }}%</p>
                                </div>
                            </div>
                            
                            <hr>
                            
                            <div class="row">
                                <div class="col-12">
                                    <h6 class="mb-2">Grading System</h6>
                                    <div class="row">
                                        <div class="col-md-2 col-4 mb-2">
                                            <span class="badge bg-success">A</span> {{ $session->grade_a_min ?? 80 }}-100%
                                        </div>
                                        <div class="col-md-2 col-4 mb-2">
                                            <span class="badge bg-info">B</span> {{ $session->grade_b_min ?? 70 }}-{{ ($session->grade_a_min ?? 80) - 1 }}%
                                        </div>
                                        <div class="col-md-2 col-4 mb-2">
                                            <span class="badge bg-primary">C</span> {{ $session->grade_c_min ?? 60 }}-{{ ($session->grade_b_min ?? 70) - 1 }}%
                                        </div>
                                        <div class="col-md-2 col-4 mb-2">
                                            <span class="badge bg-warning">D</span> {{ $session->grade_d_min ?? 50 }}-{{ ($session->grade_c_min ?? 60) - 1 }}%
                                        </div>
                                        <div class="col-md-2 col-4 mb-2">
                                            <span class="badge bg-secondary">E</span> {{ $session->grade_e_min ?? 40 }}-{{ ($session->grade_d_min ?? 50) - 1 }}%
                                        </div>
                                        <div class="col-md-2 col-4 mb-2">
                                            <span class="badge bg-danger">F</span> {{ $session->grade_f_min ?? 0 }}-{{ ($session->grade_e_min ?? 40) - 1 }}%
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        <!-- Pagination -->
        @if($sessions->hasPages())
            <div class="d-flex justify-content-center mt-4">
                {{ $sessions->links() }}
            </div>
        @endif
    @else
        <!-- No Sessions Notification Card -->
        <div class="alert text-center py-5">
            <div class="mb-3">
                <i class="fas fa-calendar-times fa-3x text-muted"></i>
            </div>
            <h4 class="fw-bold mb-3">No School Sessions Found</h4>
            <p class="mb-4">You haven't created any school sessions yet. Get started by creating your first session.</p>
            <a href="{{ route('school-sessions.create') }}" class="btn btn-primary btn-lg">
                <i class="fas fa-plus me-2"></i>Create Your First Session
            </a>
        </div>
    @endif
</div>
