<div>
    <form wire:submit.prevent="save">
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="school_name" class="form-label">School Name <span class="text-danger">*</span></label>
                <input type="text" class="form-control @error('school_name') is-invalid @enderror" 
                       id="school_name" wire:model="school_name" placeholder="Enter school name">
                @error('school_name')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-md-6 mb-3">
                <label for="school_email" class="form-label">School Email <span class="text-danger">*</span></label>
                <input type="email" class="form-control @error('school_email') is-invalid @enderror" 
                       id="school_email" wire:model="school_email" placeholder="Enter school email">
                @error('school_email')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
        </div>

        <div class="mb-3">
            <label for="school_address" class="form-label">School Address <span class="text-danger">*</span></label>
            <textarea class="form-control @error('school_address') is-invalid @enderror" 
                      id="school_address" wire:model="school_address" rows="3" 
                      placeholder="Enter complete school address"></textarea>
            @error('school_address')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="contact_phone_1" class="form-label">Contact Phone 1 <span class="text-danger">*</span></label>
                <input type="text" class="form-control @error('contact_phone_1') is-invalid @enderror" 
                       id="contact_phone_1" wire:model="contact_phone_1" placeholder="Enter primary phone number">
                @error('contact_phone_1')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-md-6 mb-3">
                <label for="contact_phone_2" class="form-label">Contact Phone 2</label>
                <input type="text" class="form-control @error('contact_phone_2') is-invalid @enderror" 
                       id="contact_phone_2" wire:model="contact_phone_2" placeholder="Enter secondary phone number (optional)">
                @error('contact_phone_2')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
        </div>

        <div class="mb-3">
            <label for="school_website" class="form-label">School Website</label>
            <input type="text" class="form-control @error('school_website') is-invalid @enderror" 
                   id="school_website" wire:model="school_website" placeholder="Enter school website (e.g., www.example.com)">
            @error('school_website')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="d-flex justify-content-end">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save me-2"></i>
                Save School Information
            </button>
        </div>
    </form>
</div>