<div>
    <form wire:submit.prevent="save">
        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="proprietorName" class="form-label">Proprietor Name</label>
                    <input type="text" wire:model="proprietorName" class="form-control" id="proprietorName" required>
                    @error('proprietorName') <div class="text-danger">{{ $message }}</div> @enderror
                </div>
            </div>
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="headTeacherName" class="form-label">Head Teacher Name</label>
                    <input type="text" wire:model="headTeacherName" class="form-control" id="headTeacherName" required>
                    @error('headTeacherName') <div class="text-danger">{{ $message }}</div> @enderror
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="form-check form-switch mb-3">
                    <input class="form-check-input" type="checkbox" wire:model="showProprietorSignature" id="showProprietorSignature">
                    <label class="form-check-label" for="showProprietorSignature">
                        Show Proprietor Signature on Results
                    </label>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-check form-switch mb-3">
                    <input class="form-check-input" type="checkbox" wire:model="showHeadTeacherSignature" id="showHeadTeacherSignature">
                    <label class="form-check-label" for="showHeadTeacherSignature">
                        Show Head Teacher Signature on Results
                    </label>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="mb-3">
                    <label class="form-label">Primary Signature on Results</label>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" wire:model="signatureType" value="proprietor" id="signatureProprietor">
                        <label class="form-check-label" for="signatureProprietor">
                            Proprietor Only
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" wire:model="signatureType" value="head_teacher" id="signatureHeadTeacher">
                        <label class="form-check-label" for="signatureHeadTeacher">
                            Head Teacher Only
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" wire:model="signatureType" value="both" id="signatureBoth">
                        <label class="form-check-label" for="signatureBoth">
                            Both Signatures
                        </label>
                    </div>
                    @error('signatureType') <div class="text-danger">{{ $message }}</div> @enderror
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i> Save Settings
                </button>
            </div>
        </div>
    </form>
</div>