<div>
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2>Staff Profile</h2>
                <a href="{{ route('staff.index') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Back to Staff List
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4 mb-4">
            <div class="card">
                <div class="card-body text-center">
                    @if($staff->profile_photo)
                        <img src="{{ asset('storage/' . $staff->profile_photo) }}" 
                             alt="{{ $staff->name }}" 
                             class="img-thumbnail mb-3" 
                             style="width: 150px; height: 150px; object-fit: cover;">
                    @else
                        <div class="bg-light border d-inline-flex align-items-center justify-content-center mb-3" 
                             style="width: 150px; height: 150px;">
                            <i class="fas fa-user text-muted" style="font-size: 60px;"></i>
                        </div>
                    @endif
                    <h4>{{ $staff->name }}</h4>
                    @if($staff->roles->count())
                        <span class="badge bg-primary fs-6">{{ $staff->roles->first()->display_name }}</span>
                    @endif
                    <div class="mt-2">
                        @if($staff->active)
                            <span class="badge bg-success">Active</span>
                        @else
                            <span class="badge bg-danger">Inactive</span>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Basic Information</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Username:</strong> <code>{{ $staff->username }}</code></p>
                            <p><strong>Email:</strong> {{ $staff->email }}</p>
                            <p><strong>Phone:</strong> {{ $staff->phone ?: 'N/A' }}</p>
                            <p><strong>Gender:</strong> {{ ucfirst($staff->gender) ?: 'N/A' }}</p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Marital Status:</strong> {{ ucfirst($staff->marital_status) ?: 'N/A' }}</p>
                            <p><strong>Date of Birth:</strong> {{ $staff->dob ? \Carbon\Carbon::parse($staff->dob)->format('M d, Y') : 'N/A' }}</p>
                            <p><strong>Address:</strong> {{ $staff->address ?: 'N/A' }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card mt-3">
                <div class="card-header">
                    <h5 class="mb-0">Location Details</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <p><strong>Country:</strong> {{ $staff->country->name ?? 'N/A' }}</p>
                        </div>
                        <div class="col-md-4">
                            <p><strong>State:</strong> {{ $staff->state->name ?? 'N/A' }}</p>
                        </div>
                        <div class="col-md-4">
                            <p><strong>City:</strong> {{ $staff->city->name ?? 'N/A' }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card mt-3 mb-3">
                <div class="card-header">
                    <h5 class="mb-0">Next of Kin</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Name:</strong> {{ $staff->nok_name ?: 'N/A' }}</p>
                            <p><strong>Phone:</strong> {{ $staff->nok_phone ?: 'N/A' }}</p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Relationship:</strong> {{ $staff->nok_relationship ?: 'N/A' }}</p>
                            <p><strong>Address:</strong> {{ $staff->nok_address ?: 'N/A' }}</p>
                        </div>
                    </div>
                </div>
            </div>

            @if($staff->classes->count())
                <div class="card mt-3">
                    <div class="card-header">
                        <h5 class="mb-0">Assigned Classes</h5>
                    </div>
                    <div class="card-body">
                        @foreach($staff->classes as $class)
                            <span class="badge bg-info me-2 mb-2">{{ $class->display_name }}</span>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>