<div>
    <div class="card">
        <div class="card-header">
            <h5>My Salary History</h5>
        </div>
        <div class="card-body">
            @if(auth()->user()->monthly_salary)
            <div class="alert alert-info mb-4">
                <strong>Current Monthly Salary:</strong> ₦{{ number_format(auth()->user()->monthly_salary, 0) }}
            </div>
            @endif

            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Period</th>
                            <th>Base Salary</th>
                            <th>Bonus</th>
                            <th>Deductions</th>
                            <th>Net Salary</th>
                            <th>Status</th>
                            <th>Paid Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($salaryHistories as $salary)
                        <tr>
                            <td>{{ $salary->month_year }}</td>
                            <td>₦{{ number_format($salary->monthly_salary, 0) }}</td>
                            <td>
                                ₦{{ number_format($salary->total_bonus, 0) }}
                            </td>
                            <td>
                                ₦{{ number_format($salary->total_deductions, 0) }}
                            </td>
                            <td>
                                <strong>₦{{ number_format($salary->net_salary, 0) }}</strong>
                                @if($salary->adjustments->count() > 0)
                                    <i class="fas fa-info-circle text-dark ms-1" style="cursor: pointer;" data-bs-toggle="collapse" data-bs-target="#adjustments-{{ $salary->id }}"></i>
                                @endif
                            </td>
                            <td>
                                <span class="badge bg-{{ $salary->status === 'paid' ? 'success' : ($salary->status === 'cancelled' ? 'danger' : 'warning') }}">
                                    {{ ucfirst($salary->status) }}
                                </span>
                            </td>
                            <td>{{ $salary->paid_at ? $salary->paid_at->format('M d, Y') : '-' }}</td>
                        </tr>
                        @if($salary->adjustments->count() > 0)
                        <tr>
                            <td colspan="7" class="p-0">
                                <div class="collapse" id="adjustments-{{ $salary->id }}">
                                    <div class="card card-body m-2">
                                        <h6>Salary Adjustments</h6>
                                        <div class="table-responsive">
                                            <table class="table table-sm">
                                                <thead>
                                                    <tr>
                                                        <th>Type</th>
                                                        <th>Amount</th>
                                                        <th>Reason</th>
                                                        <th>Date</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($salary->adjustments as $adjustment)
                                                    <tr>
                                                        <td>
                                                            <span class="badge bg-{{ $adjustment->type === 'bonus' ? 'success' : 'danger' }}">
                                                                {{ ucfirst($adjustment->type) }}
                                                            </span>
                                                        </td>
                                                        <td>₦{{ number_format($adjustment->amount, 0) }}</td>
                                                        <td>{{ $adjustment->reason }}</td>
                                                        <td>{{ $adjustment->created_at->format('M d, Y') }}</td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        @endif
                        @empty
                        <tr>
                            <td colspan="7" class="text-center text-muted">No salary history found</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            {{ $salaryHistories->links() }}
        </div>
    </div>
</div>