<div>
    <div class="card">
        <div class="card-header">
            <h4 class="card-title mb-0">My Termly Results</h4>
        </div>
        <div class="card-body">
            @if($sessions->count() > 0)
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Session</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($sessions as $session)
                                <tr>
                                    <td>{{ $session->name }} ({{ $session->start_year }}/{{ $session->end_year }})</td>
                                    <td>
                                        <span class="badge bg-success">Available</span>
                                    </td>
                                    <td>
                                        <button wire:click="viewResult({{ $session->id }})" 
                                                class="btn btn-sm btn-primary me-2 my-1 d-none d-md-inline-block">
                                            <i class="fas fa-eye me-2"></i>View
                                        </button>
                                        <button wire:click="viewResult({{ $session->id }})" 
                                                class="btn btn-xs btn-primary me-1 my-1 d-md-none">
                                            View
                                        </button>
                                        <a href="{{ route('student.results.print-termly', $session->slug) }}" 
                                           class="btn btn-sm btn-secondary my-1 d-none d-md-inline-block" 
                                           onclick="window.open(this.href, 'printResult', 'width=794,height=1123,scrollbars=yes,resizable=yes'); return false;">
                                            <i class="fas fa-print me-2"></i>Print
                                        </a>
                                        <a href="{{ route('student.results.print-termly', $session->slug) }}" 
                                           class="btn btn-xs btn-secondary my-1 d-md-none" 
                                           onclick="window.open(this.href, 'printResult', 'width=794,height=1123,scrollbars=yes,resizable=yes'); return false;">
                                            Print
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center py-4">
                    <i class="fas fa-chart-line fa-3x text-muted mb-3"></i>
                    <h5>No Results Available</h5>
                    <p class="text-muted">Your termly results will appear here once they are approved.</p>
                </div>
            @endif
        </div>
    </div>

    <!-- Result Modal -->
    @if($showModal && $resultData)
        <div class="modal fade show" style="display: block; background: rgba(0,0,0,0.5);" tabindex="-1">
            <div class="modal-dialog modal-xl modal-dialog-scrollable">
                <div class="modal-content">
                    <div class="modal-header bg-primary">
                        <h5 class="modal-title text-white">{{ $resultData['session']->name }} Result</h5>
                        <button type="button" class="btn-close btn-close-white" wire:click="closeModal"></button>
                    </div>
                    <div class="modal-body">
                        @include('results.partials.student-result-content', ['data' => $resultData, 'qrCode' => $qrCode])
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="closeModal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>