<div class="mb-3">
    <h6>{{ $salaryHistory->user->name }} - {{ $salaryHistory->month }} {{ $salaryHistory->year }}</h6>
    <p class="text-muted mb-0">Base Salary: ₦{{ number_format($salaryHistory->monthly_salary, 0) }}</p>
    <p class="text-muted">Net Salary: ₦{{ number_format($salaryHistory->net_salary, 0) }}</p>
</div>

@if($salaryHistory->adjustments->count() > 0)
    <div class="table-responsive">
        <table class="table table-sm">
            <thead>
                <tr>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Reason</th>
                    <th>Date</th>
                </tr>
            </thead>
            <tbody>
                @foreach($salaryHistory->adjustments as $adjustment)
                <tr>
                    <td>
                        <span class="badge bg-{{ $adjustment->type === 'bonus' ? 'success' : 'danger' }}">
                            {{ ucfirst($adjustment->type) }}
                        </span>
                    </td>
                    <td>₦{{ number_format($adjustment->amount, 0) }}</td>
                    <td>{{ $adjustment->reason ?? 'N/A' }}</td>
                    <td>{{ $adjustment->created_at->format('M d, Y') }}</td>
                </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr class="table-light">
                    <th>Total Bonus:</th>
                    <td colspan="3"><strong class="text-success">₦{{ number_format($salaryHistory->total_bonus, 0) }}</strong></td>
                </tr>
                <tr class="table-light">
                    <th>Total Deductions:</th>
                    <td colspan="3"><strong class="text-danger">₦{{ number_format($salaryHistory->total_deductions, 0) }}</strong></td>
                </tr>
            </tfoot>
        </table>
    </div>
@else
    <div class="text-center py-4">
        <i class="fas fa-info-circle fa-2x text-muted mb-2"></i>
        <p class="text-muted">No adjustments found for this salary record.</p>
    </div>
@endif