<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payroll - {{ $month }} {{ $year }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="{{ asset('css/school-portal.css') }}" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        @media print {
            .no-print { display: none !important; }
            body { font-size: 12px; }
            .table { font-size: 11px; }
        }
        
        .signature-cell {
            height: 60px;
            border: 1px solid #dee2e6;
            vertical-align: bottom;
        }
        
        .header-info {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .school-logo {
            max-height: 80px;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <!-- Print Button -->
        <div class="no-print mb-3">
            <button onclick="window.print()" class="btn btn-primary">
                <i class="fas fa-print me-2"></i>Print Payroll
            </button>
            <button onclick="window.close()" class="btn btn-secondary ms-2">
                <i class="fas fa-times me-2"></i>Close
            </button>
        </div>

        <!-- Header -->
        <div class="header-info">
            <img src="{{ asset('images/rosa-mys-logo.png') }}" alt="School Logo" class="school-logo">
            <h3 class="mb-1">{{ config('app.name', 'School Portal') }}</h3>
            <h4 class="mb-1">Staff Payroll</h4>
            <h5 class="text-muted">{{ $month }} {{ $year }}</h5>
            <p class="mb-0">Generated on: {{ now()->format('F d, Y') }}</p>
        </div>

        <!-- Payroll Table -->
        <div class="table-responsive">
            <table class="table table-bordered">
                <thead class="table-light">
                    <tr>
                        <th style="width: 5%;">#</th>
                        <th style="width: 20%;">Staff Name</th>
                        <th style="width: 15%;">Bank Name</th>
                        <th style="width: 15%;">Account Number</th>
                        <th style="width: 15%;">Account Name</th>
                        <th style="width: 12%;">Net Salary (₦)</th>
                        <th style="width: 9%;">Admin Sign</th>
                        <th style="width: 9%;">Staff Sign</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($payrollData as $index => $salary)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td><strong>{{ $salary->user->name }}</strong></td>
                        <td>{{ $salary->user->bank_name ?? '-' }}</td>
                        <td>{{ $salary->user->account_number ?? '-' }}</td>
                        <td>{{ $salary->user->account_name ?? '-' }}</td>
                        <td><strong>{{ number_format($salary->net_salary, 0) }}</strong></td>
                        <td class="signature-cell"></td>
                        <td class="signature-cell"></td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="table-light">
                    <tr>
                        <th colspan="5" class="text-end">Total Payroll:</th>
                        <th>₦{{ number_format($payrollData->sum('net_salary'), 0) }}</th>
                        <th colspan="2"></th>
                    </tr>
                </tfoot>
            </table>
        </div>

        <!-- Footer -->
        <div class="row mt-5">
            <div class="col-md-6">
                <div class="border p-3">
                    <h6>Prepared By:</h6>
                    <p class="mb-1"><strong>{{ auth()->user()->name }}</strong></p>
                    <p class="mb-1">{{ ucfirst(auth()->user()->roles->first()->name ?? 'Staff') }}</p>
                    <p class="mb-0">Date: {{ now()->format('F d, Y') }}</p>
                    <div style="height: 50px; border-top: 1px solid #000; margin-top: 30px; text-align: center; padding-top: 5px;">
                        Signature
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="border p-3">
                    <h6>Approved By:</h6>
                    <p class="mb-1">Head Teacher/Administrator</p>
                    <p class="mb-0">Date: _________________</p>
                    <div style="height: 50px; border-top: 1px solid #000; margin-top: 30px; text-align: center; padding-top: 5px;">
                        Signature
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Auto-print when page loads (optional)
        // window.onload = function() { window.print(); }
    </script>
</body>
</html>