<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Result - {{ $data['student']->name }}</title>
    <link href="{{ asset('vendor/bootstrap-5.3.7.min.css') }}" rel="stylesheet">
    <link href="{{ asset('vendor/fontawesome-6.7.2/css/all.min.css') }}" rel="stylesheet">
    <style>
        .report-title {
            font-size: 20px;
            font-style: italic;
            font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
            height: 50px;
            padding-top: 10px;
            margin-top: 0px;
            background-color: #757575 !important;
        }

        .add-border {
            border: 1px solid #CCC;
        }

        .padding0 {
            padding: 0px
        }

        .margint10 {
            margin-top: 10px
        }

        .margint5 {
            margin-top: 5px
        }

        .photo {
            width: 100px;
            height: 100px;
            margin: auto;
            margin-bottom: 10px
        }

        .result-header {
            font-size: 9px;
            background-color: #757575 !important;
        }

        .fontwhite {
            color: #FFF !important;
        }

        .result-body {
            font-size: 10px;
            font-weight: bolder;
        }

        .result-body2 {
            font-size: 9px;
            font-weight: normal;
        }

        .result-body3 {
            font-size: 8px;
            font-weight: normal;
        }

        .report-body2 {
            font-size: 10px;
            font-weight: bold;
        }

        .fontnormal {
            font-weight: normal;
        }

        .school-name {
            font-size: 20px;
            font-family: Georgia, "Times New Roman", Times, serif;
            font-weight: bolder;
        }

        .contacts {
            font-size: 11px;
            font-weight: bold;
        }

        .bgimage {
            background-image: url(images/signin_feild_bg.gif) !important;
            background-repeat: repeat;
            -webkit-print-color-adjust: exact;
        }

        @media print {
            .no-print {
                display: none;
            }

            body {
                margin: 0;
            }
        }
    </style>
</head>
<body>
<div style="width:99%;margin:auto;margin-top:0px;padding:10px;margin-bottom:20px" class="bgimage add-border">

    <!-- START OF BANNER DIV -->
    <div class="row">
        <div class="col-xs-2">
            <img src="{{ asset('images/rosa-mys-logo.png') }}" alt="school logo" width="100" class="img-responsive"
                 style="height:100px;border-radius:5px">
        </div>
        <div class="col-xs-10">
            <div class="row pull-right">
                <div class="col-xs-12 school-name">{{ config('app.name') }}</div>
            </div>
            <div style="clear:both"></div>
            <div class="row pull-right">
                <div class="col-xs-12 contacts margint5">Road 2 house 14 ,Beverly Hills Trans-Nkisi, G.R.A . Onitsha
                    Anambra State.
                </div>
            </div>
            <div style="clear:both"></div>
            <div class="row pull-right">
                <div class="col-xs-12 contacts margint5"><i class="fa fa-desktop"></i> rosamysticaschool.org |
                    <i class="fa fa-envelope"></i> Info@rosamysticaschool.org
                </div>
            </div>
            <div style="clear:both"></div>
            <div class="row pull-right">
                <div class="col-xs-12 contacts margint5"><i class="fa fa-phone"></i>
                    Phone: 09012628700 , 08034726594
                </div>
            </div>
            <div style="clear:both"></div>
        </div>
    </div>
    <!-- END OF BANNER DIV -->

    <!-- START OF REPORT TITLE DIV -->
    <div class="row">
        <div class="col-xs-12">
            <div class="text-center report-title margint10 fontwhite">&nbsp;
                Termly Report
            </div>
        </div>
    </div>
    <!-- END OF REPORT TITLE DIV -->

    <!-- START OF DESCRIPTION SECTION DIV -->
    <div class="row margint10">
        <div class="col-xs-12">
            <div class="col-xs-10 padding0">
                <table width="100%" class="table-condensed table-striped table-responsive report-body2">
                    <tbody>
                    <tr>
                        <td>
                            <div class="row">
                                <div class="col-xs-12"><strong>Student ID: </strong>
                                    <span class="fontnormal">{{ $data['student']->student_id ?? 'N/A' }}</span></div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <div class="row">
                                <div class="col-xs-12"><strong>Name: </strong>
                                    <span class="fontnormal">{{ $data['student']->name }}</span></div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <div class="row">
                                <div class="col-xs-12">
                                    <strong>Academic Session:</strong> <span class="fontnormal">{{ $data['session']->start_year }}/{{ $data['session']->end_year }}</span>
                                    &nbsp;
                                    <strong>Term:</strong> <span class="fontnormal">{{ $data['session']->name }}</span>
                                    &nbsp;
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <div class="row">
                                <div class="col-xs-12">
                                    <strong>Next Term Begins:</strong> <span
                                        class="fontnormal">{{ $data['session']->end_date ? $data['session']->end_date->addDays(7)->format('M j\\s\\u\\p, Y') : 'TBA' }}</span>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <div class="row">
                                <div class="col-xs-12">
                                    <strong>Gender:</strong> <span
                                        class="fontnormal">{{ ucfirst($data['student']->gender ?? 'N/A') }}</span>&nbsp;
                                    <strong>Class:</strong> <span
                                        class="fontnormal">{{ $data['class']->display_name }}</span> &nbsp;
                                    <strong>Remarks:</strong> &nbsp;<span class="text-system"><font
                                            color="{{ $data['studentData']['remark'] === 'Pass' ? 'green' : 'red' }}">{{ $data['studentData']['remark'] }}</font></span>
                                </div>
                            </div>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="col-xs-2">
                <img
                    src="{{ $data['student']->profile_photo ? asset('storage/' . $data['student']->profile_photo) : asset('images/user-avatar.png') }}"
                    alt="photo" class="img-responsive photo" style="border-radius:5px">
            </div>
        </div>
    </div>
    <!-- END OF DESCRIPTION SECTION DIV -->

    <!-- START OF result SECTION DIV -->
    <div class="row">
        <div class="col-xs-12">
            <table width="99%" border="0" align="left" class="table-condensed table-responsive">
                <tbody>
                <tr>
                    <td align="left" valign="top">
                        <table width="100%" class="table-condensed table-striped table-responsive table-bordered"
                               border="1">
                            <thead>
                            <tr class="result-header">
                                <td align="center" width="20%" class="fontwhite">Subject</td>
                                <td align="center" class="fontwhite">CA <br>(40%)</td>
                                <td align="center" class="fontwhite">Exam <br>(60%)</td>
                                <td align="center" class="fontwhite">Total <br> Score <br>(100%)</td>
                                <td align="center" class="fontwhite">Grade</td>
                                <td align="center" class="fontwhite" width="10%">Remarks</td>
                            </tr>
                            </thead>
                            <tbody class="result-body">
                            @foreach($data['subjects'] as $subject)
                                @php
                                    $subjectResult = $data['studentData']['subjects'][$subject->id] ?? null;
                                    $total = intval($subjectResult['total'] ?? 0);
                                    $grade = $subjectResult['grade'] ?? 'F';
                                    $remark = $total >= 70 ? 'Excellent' : ($total >= 60 ? 'Very Good' : ($total >= 50 ? 'Good' : ($total >= 45 ? 'Average' : ($total >= 40 ? 'Poor' : 'Fail'))));
                                @endphp
                                <tr>
                                    <td nowrap="nowrap">{{ strtoupper($subject->display_name) }}</td>
                                    <td>{{ intval($subjectResult['ca_score'] ?? 0) }}</td>
                                    <td>{{ intval($subjectResult['exam_score'] ?? 0) }}</td>
                                    <td>{{ $total }}</td>
                                    <td>{{ $grade }}</td>
                                    <td>{{ $remark }}</td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </td>

                    @if($data['approval'])
                        <td align="left" valign="top" style="padding-left:5px;padding-right:5px">
                            <table width="98%" class="table-condensed table-striped table-responsive table-bordered"
                                   border="1">
                                <thead></thead>
                                <tbody class="result-body3">
                                <tr class="result-header">
                                    <td width="" height="20" align="center" class="fontwhite" nowrap="nowrap">AFFECTIVE
                                        TRAITS
                                    </td>
                                    <td width="39">&nbsp;</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Punctuality</td>
                                    <td align="center" class="">{{ $data['approval']->punctuality }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Mental Alertness</td>
                                    <td align="center">{{ $data['approval']->mental_alertness }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Attentiveness</td>
                                    <td align="center">{{ $data['approval']->attentiveness }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Respect</td>
                                    <td align="center">{{ $data['approval']->respect }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Neatness</td>
                                    <td align="center">{{ $data['approval']->neatness }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Politeness</td>
                                    <td align="center">{{ $data['approval']->politeness }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Honesty</td>
                                    <td align="center">{{ $data['approval']->honesty }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Relationship with Peers</td>
                                    <td align="center">{{ $data['approval']->relationship_with_peers }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Attitude To School</td>
                                    <td align="center">{{ $data['approval']->attitude_to_school }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Spirit of Team Work</td>
                                    <td align="center">{{ $data['approval']->teamwork }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Completes School Work Promptly</td>
                                    <td align="center">{{ $data['approval']->completes_school_work_promptly }}</td>
                                </tr>
                                <tr class="result-header">
                                    <td height="20" nowrap="nowrap" class="fontwhite" align="center">&nbsp;&nbsp;&nbsp;PSYCHOMOTOR
                                        SKILLS
                                    </td>
                                    <td align="center">&nbsp;</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Reading</td>
                                    <td align="center">{{ $data['approval']->reading }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Verbal Fluency / Diction</td>
                                    <td align="center">{{ $data['approval']->verbal_fluency_diction }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Handwriting</td>
                                    <td align="center">{{ $data['approval']->handwriting }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Musical Skills</td>
                                    <td align="center">{{ $data['approval']->musical_skills }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Creative Arts</td>
                                    <td align="center">{{ $data['approval']->creative_arts }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Physical Education</td>
                                    <td align="center">{{ $data['approval']->physical_education }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;General Reasoning</td>
                                    <td align="center">{{ $data['approval']->general_reasoning }}</td>
                                </tr>
                                </tbody>
                            </table>
                        </td>
                    @endif
                </tr>
                </tbody>
            </table>
        </div>
    </div>
    <!-- END OF result SECTION DIV -->

    <!-- START OF report summary SECTION DIV -->
    <div class="row margint10">
        <div class="col-xs-12">
            <div class="col-xs-5" style="padding-left:0px">
                <table width="100%" class="table-condensed table-striped table-responsive table-bordered" border="1">
                    <thead>
                    <tr class="result-header">
                        <td colspan="2" align="center" class="fontwhite">Report Summary</td>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td width="50%" nowrap="nowrap" class="result-body"><strong>Overall Total Score </strong></td>
                        <td width="50%" class="result-body2">{{ intval($data['studentData']['grand_total']) }} out
                            of {{ count($data['subjects']) * 100 }}</td>
                    </tr>
                    <tr>
                        <td nowrap="nowrap" class="result-body"><strong>Average Score</strong></td>
                        <td class="result-body2">{{ $data['studentData']['average'] }}</td>
                    </tr>
                    <tr>
                        <td nowrap="nowrap" class="result-body"><strong>Total Subjects Offered In Class</strong></td>
                        <td class="result-body2">{{ count($data['subjects']) }}</td>
                    </tr>
                    <tr>
                        <td nowrap="nowrap" class="result-body"><strong>Total Subjects Taken</strong></td>
                        <td class="result-body2">{{ count($data['subjects']) }}</td>
                    </tr>
                    @if($data['approval'])
                        <tr>
                            <td nowrap="nowrap" class="result-body"><strong>Head Teacher's Comment</strong></td>
                            <td class="result-body2">{{ $data['approval']->principal_remarks }}</td>
                        </tr>
                    @endif
                    </tbody>
                </table>
            </div>

            <div class="col-xs-4" style="padding-right:0px">
                <table width="100%" class="table-condensed table-striped table-responsive table-bordered" border="1">
                    <thead style="">
                    <tr class="result-header">
                        <td colspan="2" align="center" class="fontwhite">Grading System</td>
                    </tr>
                    </thead>
                    <tbody class="result-body">
                    <tr>
                        <td width="50%" nowrap="nowrap"><strong>{{ $data['session']->grade_a_min }}% - 100%</strong>
                        </td>
                        <td width="50%" class="result-body2">A - Excellent</td>
                    </tr>
                    <tr>
                        <td nowrap="nowrap"><strong>{{ $data['session']->grade_b_min }}%
                                - {{ $data['session']->grade_a_min - 1 }}%</strong></td>
                        <td class="result-body2">B - Very Good</td>
                    </tr>
                    <tr>
                        <td nowrap="nowrap"><strong>{{ $data['session']->grade_c_min }}%
                                - {{ $data['session']->grade_b_min - 1 }}%</strong></td>
                        <td class="result-body2">C - Good</td>
                    </tr>
                    <tr>
                        <td nowrap="nowrap"><strong>{{ $data['session']->grade_d_min }}%
                                - {{ $data['session']->grade_c_min - 1 }}%</strong></td>
                        <td class="result-body2">D - Average</td>
                    </tr>
                    <tr>
                        <td nowrap="nowrap"><strong>{{ $data['session']->grade_e_min }}%
                                - {{ $data['session']->grade_d_min - 1 }}%</strong></td>
                        <td class="result-body2">E - Poor</td>
                    </tr>
                    <tr>
                        <td><strong>0% - {{ $data['session']->grade_e_min - 1 }}%</strong></td>
                        <td class="result-body2">F - Fail</td>
                    </tr>
                    <tr class="result-header">
                        <td colspan="2" class="result-body fontwhite">
                            CA : Continous Assessment <br>
                            Avg Score = Tot Score / No. Subj. Offered
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>

            <div class="col-xs-3">
                <table width="100%" class="table-condensed table-responsive">
                    <tbody class="result-body">
                    <tr>
                        <td width="50%" align="center" nowrap="nowrap">
                            <br>
                            <img src="{{ asset('images/head-teacher-sign.jpg') }}"
                                 style="width:150px;height:100px;border-radius:5px" alt="stamp"
                                 class="img-responsive"><br></td>
                    </tr>
                    <tr>
                        <td align="center" nowrap="nowrap" class="fontwhite result-header">Head Teacher</td>
                    </tr>
                    <tr>
                        <td align="center" nowrap="nowrap" class="fontwhite result-header">{{ config('app.name') }}</td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <!-- END OF report summary SECTION DIV -->

    <div class="no-print">
        <button class="btn btn-primary" onclick="window.print()">
            <i class="fa fa-print"></i> Print Result Sheet
        </button>
        <button class="btn btn-secondary" onclick="window.close()">
            <i class="fa fa-times"></i> Close
        </button>
    </div>
</div>
</body>
</html>
