<div style="width:100%;margin:auto;padding:8px;" class="main-container">
    <!-- START OF BANNER DIV -->
    <div class="d-flex align-items-center justify-content-center mb-3" style="gap: 15px;">
        <img src="{{ asset('images/rosa-mys-logo.png') }}" alt="school logo" style="width: auto; height: 80px; border-radius: 5px;">
        <div class="text-center">
            <div style="font-size: 24px; font-family: Georgia, 'Times New Roman', Times, serif; font-weight: bolder; margin-bottom: 5px;">{{ settings('school_name', config('app.name')) }}</div>
            @if(settings('school_address'))
                <div style="font-size: 12px; font-weight: bold; margin-bottom: 3px;">{{ settings('school_address') }}</div>
            @endif
            <div style="font-size: 12px; font-weight: bold; margin-bottom: 3px;">
                @if(settings('school_website'))
                    <i class="fa fa-desktop"></i> {{ settings('school_website') }}
                @endif
                @if(settings('school_email'))
                    @if(settings('school_website')) | @endif
                    <i class="fa fa-envelope"></i> {{ settings('school_email') }}
                @endif
            </div>
            @if(settings('school_phone'))
                <div style="font-size: 12px; font-weight: bold; margin-bottom: 3px;"><i class="fa fa-phone"></i> Phone: {{ settings('school_phone') }}</div>
            @endif
        </div>
    </div>
    <!-- END OF BANNER DIV -->

    <!-- START OF REPORT TITLE DIV -->
    <div class="text-center bg-secondary text-white py-2 mb-3" style="font-size: 16px; font-style: italic;">
        Termly Report
    </div>
    <!-- END OF REPORT TITLE DIV -->

    <!-- START OF DESCRIPTION SECTION DIV -->
    <div class="row mb-3">
        <div class="col-lg-8">
            <table class="table table-sm">
                <tbody>
                <tr>
                    <td><strong>Student ID:</strong> {{ $data['student']->student_id ?? 'N/A' }}</td>
                </tr>
                <tr>
                    <td><strong>Name:</strong> {{ $data['student']->name }}</td>
                </tr>
                <tr>
                    <td>
                        <strong>Academic Session:</strong> {{ $data['session']->start_year }}/{{ $data['session']->end_year }}
                        &nbsp; <strong>Term:</strong> {{ $data['session']->name }}
                    </td>
                </tr>
                <tr>
                    <td><strong>Next Term Begins:</strong> {{ $data['session']->next_session_start_date ? $data['session']->next_session_start_date->format('M jS, Y') : 'TBA' }}</td>
                </tr>
                <tr>
                    <td>
                        <strong>Gender:</strong> {{ ucfirst($data['student']->gender ?? 'N/A') }}&nbsp;
                        <strong>Class:</strong> {{ $data['class']->display_name }}&nbsp;
                        <strong>Remarks:</strong> <span style="color: {{ $data['studentData']['remark'] === 'Pass' ? 'green' : 'red' }}">{{ $data['studentData']['remark'] }}</span>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
        <div class="col-lg-4 text-center">
            <img src="{{ $data['student']->profile_photo ? asset('storage/' . $data['student']->profile_photo) : asset('images/user-avatar.png') }}" 
                 alt="photo" class="img-thumbnail" style="width: 80px; height: 80px; object-fit: cover;">
        </div>
    </div>
    <!-- END OF DESCRIPTION SECTION DIV -->

    <!-- START OF RESULT SECTION DIV -->
    <div class="row">
        <div class="col-lg-8">
            <table class="table table-bordered table-striped">
                <thead class="table-dark">
                    <tr class="text-center">
                        <th>Subject</th>
                        <th>CA<br>(40%)</th>
                        <th>Exam<br>(60%)</th>
                        <th>Total<br>Score<br>(100%)</th>
                        <th>Grade</th>
                        <th>Remarks</th>
                    </tr>
                </thead>
                <tbody class="text-center">
                    @foreach($data['subjects'] as $subject)
                        @php
                            $subjectResult = $data['studentData']['subjects'][$subject->id] ?? null;
                            $caScore = $subjectResult['ca_score'] ?? 0;
                            $examScore = $subjectResult['exam_score'] ?? 0;
                            $caAbsent = $subjectResult['ca_absent'] ?? false;
                            $examAbsent = $subjectResult['exam_absent'] ?? false;
                            $total = intval($subjectResult['total'] ?? 0);
                            $grade = $subjectResult['grade'] ?? 'F';
                            $remark = $total >= 70 ? 'Excellent' : ($total >= 60 ? 'Very Good' : ($total >= 50 ? 'Good' : ($total >= 45 ? 'Average' : ($total >= 40 ? 'Poor' : 'Fail'))));
                        @endphp
                        <tr>
                            <td class="text-start">{{ strtoupper($subject->display_name) }}</td>
                            <td>{{ $caAbsent ? 'Absent' : intval($caScore) }}</td>
                            <td>{{ $examAbsent ? 'Absent' : intval($examScore) }}</td>
                            <td>{{ $total }}</td>
                            <td>{{ $grade }}</td>
                            <td>{{ $remark }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        @if($data['approval'])
        <div class="col-lg-4">
            <table class="table table-bordered table-striped table-sm">
                <thead class="table-dark">
                    <tr>
                        <th colspan="2" class="text-center">AFFECTIVE TRAITS</th>
                    </tr>
                </thead>
                <tbody>
                    <tr><td>Punctuality</td><td class="text-center">{{ intval($data['approval']->punctuality) }}</td></tr>
                    <tr><td>Mental Alertness</td><td class="text-center">{{ intval($data['approval']->mental_alertness) }}</td></tr>
                    <tr><td>Attentiveness</td><td class="text-center">{{ intval($data['approval']->attentiveness) }}</td></tr>
                    <tr><td>Respect</td><td class="text-center">{{ intval($data['approval']->respect) }}</td></tr>
                    <tr><td>Neatness</td><td class="text-center">{{ intval($data['approval']->neatness) }}</td></tr>
                    <tr><td>Politeness</td><td class="text-center">{{ intval($data['approval']->politeness) }}</td></tr>
                    <tr><td>Honesty</td><td class="text-center">{{ intval($data['approval']->honesty) }}</td></tr>
                    <tr><td>Relationship with Peers</td><td class="text-center">{{ intval($data['approval']->relationship_with_peers) }}</td></tr>
                    <tr><td>Attitude To School</td><td class="text-center">{{ intval($data['approval']->attitude_to_school) }}</td></tr>
                    <tr><td>Spirit of Team Work</td><td class="text-center">{{ intval($data['approval']->teamwork) }}</td></tr>
                    <tr><td>Completes School Work Promptly</td><td class="text-center">{{ intval($data['approval']->completes_school_work_promptly) }}</td></tr>
                </tbody>
                <thead class="table-dark">
                    <tr>
                        <th colspan="2" class="text-center">PSYCHOMOTOR SKILLS</th>
                    </tr>
                </thead>
                <tbody>
                    <tr><td>Reading</td><td class="text-center">{{ intval($data['approval']->reading) }}</td></tr>
                    <tr><td>Verbal Fluency / Diction</td><td class="text-center">{{ intval($data['approval']->verbal_fluency_diction) }}</td></tr>
                    <tr><td>Handwriting</td><td class="text-center">{{ intval($data['approval']->handwriting) }}</td></tr>
                    <tr><td>Musical Skills</td><td class="text-center">{{ intval($data['approval']->musical_skills) }}</td></tr>
                    <tr><td>Creative Arts</td><td class="text-center">{{ intval($data['approval']->creative_arts) }}</td></tr>
                    <tr><td>Physical Education</td><td class="text-center">{{ intval($data['approval']->physical_education) }}</td></tr>
                    <tr><td>General Reasoning</td><td class="text-center">{{ intval($data['approval']->general_reasoning) }}</td></tr>
                </tbody>
            </table>
        </div>
        @endif
    </div>
    <!-- END OF RESULT SECTION DIV -->

    <!-- START OF REPORT SUMMARY SECTION DIV -->
    <div class="row mt-3">
        <div class="col-lg-6">
            <table class="table table-bordered">
                <thead class="table-dark">
                    <tr>
                        <th colspan="2" class="text-center">Report Summary</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><strong>Overall Total Score</strong></td>
                        <td>{{ intval($data['studentData']['grand_total']) }} out of {{ count($data['subjects']) * 100 }}</td>
                    </tr>
                    <tr>
                        <td><strong>Average Score</strong></td>
                        <td>{{ $data['studentData']['average'] }}</td>
                    </tr>
                    <tr>
                        <td><strong>Total Subjects Offered</strong></td>
                        <td>{{ count($data['subjects']) }}</td>
                    </tr>
                    @if($data['approval'])
                    <tr>
                        <td><strong>Head Teacher's Comment</strong></td>
                        <td>{{ $data['approval']->principal_remarks }}</td>
                    </tr>
                    @endif
                </tbody>
            </table>
        </div>

        <div class="col-lg-6">
            <table class="table table-bordered">
                <thead class="table-dark">
                    <tr>
                        <th colspan="2" class="text-center">Grading System</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><strong>{{ $data['session']->grade_a_min }}% - 100%</strong></td>
                        <td>A - Excellent</td>
                    </tr>
                    <tr>
                        <td><strong>{{ $data['session']->grade_b_min }}% - {{ $data['session']->grade_a_min - 1 }}%</strong></td>
                        <td>B - Very Good</td>
                    </tr>
                    <tr>
                        <td><strong>{{ $data['session']->grade_c_min }}% - {{ $data['session']->grade_b_min - 1 }}%</strong></td>
                        <td>C - Good</td>
                    </tr>
                    <tr>
                        <td><strong>{{ $data['session']->grade_d_min }}% - {{ $data['session']->grade_c_min - 1 }}%</strong></td>
                        <td>D - Average</td>
                    </tr>
                    <tr>
                        <td><strong>{{ $data['session']->grade_e_min }}% - {{ $data['session']->grade_d_min - 1 }}%</strong></td>
                        <td>E - Poor</td>
                    </tr>
                    <tr>
                        <td><strong>0% - {{ $data['session']->grade_e_min - 1 }}%</strong></td>
                        <td>F - Fail</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <!-- END OF REPORT SUMMARY SECTION DIV -->
</div>