<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Class Annual Result - {{ $data['class']->display_name }} {{ $data['year'] }}/{{ $data['year'] + 1 }}</title>
    <link href="{{ asset('vendor/bootstrap-5.3.7.min.css') }}" rel="stylesheet">
    <link href="{{ asset('vendor/fontawesome-6.7.2/css/all.min.css') }}" rel="stylesheet">
    <link href="{{ asset('css/school-portal.css') }}" rel="stylesheet">
    <style>
        @page {
            size: A4 landscape;
            margin: 0.3in;
        }

        .report-title {
            font-size: 12px;
            font-style: italic;
            font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
            height: 25px;
            padding-top: 5px;
            margin-top: 0px;
            background-color: #757575 !important;
        }

        .add-border {
            border: 1px solid #CCC;
        }

        .header-flex {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 15px;
        }

        .school-logo {
            width: auto;
            height: 60px;
            border-radius: 5px;
            flex-shrink: 0;
        }

        .school-info {
            text-align: center;
        }

        .result-header {
            font-size: 7px;
            background-color: #757575 !important;
            padding: 2px !important;
        }

        .fontwhite {
            color: #FFF !important;
        }

        .result-body {
            font-size: 7px;
            font-weight: bolder;
            padding: 1px 2px !important;
        }

        .result-body2 {
            font-size: 6px;
            font-weight: normal;
        }

        .report-body2 {
            font-size: 7px;
            font-weight: bold;
        }

        .fontnormal {
            font-weight: normal;
        }

        .school-name {
            font-size: 14px;
            font-family: Georgia, "Times New Roman", Times, serif;
            font-weight: bolder;
            margin-bottom: 3px;
        }

        .contacts {
            font-size: 8px;
            font-weight: bold;
            margin-bottom: 2px;
        }

        .bgimage {
            background-image: url(images/signin_feild_bg.gif) !important;
            background-repeat: repeat;
            -webkit-print-color-adjust: exact;
        }

        @media print {
            .no-print {
                display: none;
            }

            body {
                margin: 0;
            }
        }
    </style>
</head>
<body class="a4-landscape-min">
<div style="width:99%;margin:auto;margin-top:0px;padding:8px;margin-bottom:15px" class="bgimage add-border main-container">

    <!-- START OF BANNER DIV -->
    <div class="header-flex">
        <img src="{{ asset('images/rosa-mys-logo.png') }}" alt="school logo" class="school-logo">
        <div class="school-info">
            <div class="school-name">{{ $data['school_info']['name'] }}</div>
            @if($data['school_info']['address'])
            <div class="contacts">{{ $data['school_info']['address'] }}</div>
            @endif
            <div class="contacts">
                @if($data['school_info']['website'])
                    <i class="fa fa-desktop"></i> {{ $data['school_info']['website'] }}
                @endif
                @if($data['school_info']['website'] && $data['school_info']['email']) | @endif
                @if($data['school_info']['email'])
                    <i class="fa fa-envelope"></i> {{ $data['school_info']['email'] }}
                @endif
            </div>
            @if($data['school_info']['phone_1'] || $data['school_info']['phone_2'])
            <div class="contacts">
                <i class="fa fa-phone"></i> Phone: 
                {{ $data['school_info']['phone_1'] }}
                @if($data['school_info']['phone_1'] && $data['school_info']['phone_2']) , @endif
                {{ $data['school_info']['phone_2'] }}
            </div>
            @endif
        </div>
        @if($qrCode)
            <div class="qr-code" style="flex-shrink: 0;">
                {!! $qrCode !!}
            </div>
        @endif
    </div>
    <!-- END OF BANNER DIV -->

    <!-- START OF REPORT TITLE DIV -->
    <div class="text-center report-title fontwhite" style="margin-top: 8px;">
        Class Annual Report
    </div>
    <!-- END OF REPORT TITLE DIV -->

    <!-- START OF DESCRIPTION SECTION DIV -->
    <div style="margin-top: 10px;">
        <table class="table-condensed report-body2">
            <tbody>
            <tr>
                <td><strong>Class:</strong> <span class="fontnormal">{{ $data['class']->display_name }}@if($data['batch']) - {{ $data['batch']->name }}@endif</span></td>
                <td><strong>Academic Year:</strong> <span class="fontnormal">{{ $data['year'] }}/{{ $data['year'] + 1 }}</span></td>
                <td><strong>Total Students:</strong> <span class="fontnormal">{{ count($data['annualData']) }}</span></td>
            </tr>
            </tbody>
        </table>
    </div>
    <!-- END OF DESCRIPTION SECTION DIV -->

    <!-- START OF RESULT SECTION DIV -->
    <div class="row">
        <div class="col-xs-12">
            <table width="100%" class="table-condensed table-striped table-responsive table-bordered" border="1">
                <thead>
                <tr class="result-header">
                    <td rowspan="2" align="center" class="fontwhite">Position</td>
                    <td rowspan="2" align="center" class="fontwhite">Student Name</td>
                    @foreach($data['sessions'] as $session)
                        <td colspan="2" align="center" class="fontwhite">{{ $session->name }}</td>
                    @endforeach
                    @php
                        $maxAnnualScore = !empty($data['annualData']) ? $data['annualData'][0]['total_possible_score'] ?? 0 : 0;
                    @endphp
                    <td rowspan="2" align="center" class="fontwhite">Annual Total ({{ $maxAnnualScore }})</td>
                    <td rowspan="2" align="center" class="fontwhite">Total Average @if(!empty($data['annualData']))({{ 100 * count($data['subjects']) }})@endif</td>
                    <td rowspan="2" align="center" class="fontwhite">Annual Avg % (100%)</td>
                    <td rowspan="2" align="center" class="fontwhite">Comment</td>
                </tr>
                <tr class="result-header">
                    @foreach($data['sessions'] as $session)
                        @php
                            $maxSessionScore = !empty($data['annualData']) ? $data['annualData'][0]['sessions'][$session->id]['total_possible_score'] ?? 0 : 0;
                        @endphp
                        <td align="center" class="fontwhite">Total ({{ $maxSessionScore }})</td>
                        <td align="center" class="fontwhite">Average</td>
                    @endforeach
                </tr>
                </thead>
                <tbody class="result-body" style="text-align: center; vertical-align: middle;">
                @foreach($data['annualData'] as $studentData)
                    <tr>
                        <td><strong>{{ $studentData['position_suffix'] }}</strong></td>
                        <td nowrap="nowrap" style="text-align: left;"><strong>{{ strtoupper($studentData['student']->name) }}</strong></td>
                        @foreach($data['sessions'] as $session)
                            @php
                                $sessionData = $studentData['sessions'][$session->id] ?? null;
                            @endphp
                            <td>{{ $sessionData['grand_total'] ?? 0 }}</td>
                            <td>{{ $sessionData['average'] ?? 0 }}</td>
                        @endforeach
                        <td><strong>{{ $studentData['annual_grand_total'] }}</strong></td>
                        <td><strong>{{ $studentData['total_average'] }}</strong></td>
                        <td><strong>{{ $studentData['annual_average'] }}%</strong></td>
                        @php
                            $passPercentage = settings('annual_pass_percentage', 50);
                            $comment = $studentData['annual_average'] >= $passPercentage ? 'Promoted' : 'Demoted';
                        @endphp
                        <td style="color: {{ $studentData['annual_average'] >= $passPercentage ? 'green' : 'red' }}"><strong>{{ $comment }}</strong></td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <!-- END OF RESULT SECTION DIV -->

    <!-- Teachers and Timestamp Section -->
    @if(settings('show_class_teachers_on_print', true) || settings('show_timestamp', true))
    <div style="margin-top: 20px; border-top: 1px solid #ccc; padding-top: 10px;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            @if(settings('show_class_teachers_on_print', true))
            <div>
                <strong class="result-body">Class Teachers:</strong>
                <span class="result-body2">
                    @if($data['teachers'] && $data['teachers']->count() > 0)
                        {{ $data['teachers']->pluck('name')->join(', ') }}
                    @else
                        No teachers assigned
                    @endif
                </span>
            </div>
            @endif
            @php
                $signatureType = settings('signature_type', 'head_teacher');
                $showProprietor = settings('show_proprietor_signature', false);
                $showHeadTeacher = settings('show_head_teacher_signature', true);
                $proprietorName = settings('proprietor_name', 'School Proprietor');
                $headTeacherName = settings('head_teacher_name', 'Head Teacher');
            @endphp
            @if($signatureType === 'both')
                <div style="text-align: center; display: flex; gap: 20px; justify-content: center;">
                    @if($showProprietor)
                    <div>
                        <img src="{{ asset('images/proprietor-sign.jpg') }}" style="width:70px;height:35px;border-radius:3px" alt="proprietor signature" class="img-responsive">
                        <div class="result-body2" style="margin-top: 3px;">{{ $proprietorName }}</div>
                        <div class="result-body2">Proprietor</div>
                        <div class="result-body2">{{ $data['school_info']['name'] }}</div>
                    </div>
                    @endif
                    @if($showHeadTeacher)
                    <div>
                        <img src="{{ asset('images/head-teacher-sign.jpg') }}" style="width:70px;height:35px;border-radius:3px" alt="head teacher signature" class="img-responsive">
                        <div class="result-body2" style="margin-top: 3px;">{{ $headTeacherName }}</div>
                        <div class="result-body2">Head Teacher</div>
                        <div class="result-body2">{{ $data['school_info']['name'] }}</div>
                    </div>
                    @endif
                </div>
            @elseif($signatureType === 'proprietor' && $showProprietor)
                <div style="text-align: center;">
                    <img src="{{ asset('images/proprietor-sign.jpg') }}" style="width:80px;height:40px;border-radius:3px" alt="proprietor signature" class="img-responsive">
                    <div class="result-body2" style="margin-top: 3px;">{{ $proprietorName }}</div>
                    <div class="result-body2">Proprietor</div>
                    <div class="result-body2">{{ $data['school_info']['name'] }}</div>
                </div>
            @elseif($signatureType === 'head_teacher' && $showHeadTeacher)
                <div style="text-align: center;">
                    <img src="{{ asset('images/head-teacher-sign.jpg') }}" style="width:80px;height:40px;border-radius:3px" alt="head teacher signature" class="img-responsive">
                    <div class="result-body2" style="margin-top: 3px;">{{ $headTeacherName }}</div>
                    <div class="result-body2">Head Teacher</div>
                    <div class="result-body2">{{ $data['school_info']['name'] }}</div>
                </div>
            @endif
            @if(settings('show_timestamp', true))
            <div>
                <span class="result-body2">Generated on: {{ $data['generated_at']->format('M d, Y \a\t h:i A') }}</span>
            </div>
            @endif
        </div>
    </div>
    @endif

    <div class="no-print" style="margin-top: 30px;">
        <button class="btn btn-primary" onclick="window.print()">
            <i class="fa fa-print"></i> Print Class Annual Result
        </button>
        <button class="btn btn-secondary" onclick="window.close()">
            <i class="fa fa-times"></i> Close
        </button>
    </div>
</div>
</body>
</html>