<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Annual Result - {{ $data['student']->name }}</title>
    <link href="{{ asset('vendor/bootstrap-5.3.7.min.css') }}" rel="stylesheet">
    <link href="{{ asset('vendor/fontawesome-6.7.2/css/all.min.css') }}" rel="stylesheet">
    <link href="{{ asset('css/school-portal.css') }}" rel="stylesheet">
    <style>
        @page {
            size: A4;
            margin: 0.5in;
        }

        .report-title {
            font-size: 16px;
            font-style: italic;
            font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
            height: 35px;
            padding-top: 8px;
            margin-top: 0px;
            background-color: #757575 !important;
        }

        .add-border {
            border: 1px solid #CCC;
        }

        .header-flex {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 15px;
        }

        .school-logo {
            width: auto;
            height: 80px;
            border-radius: 5px;
            flex-shrink: 0;
        }

        .school-info {
            text-align: center;
        }

        .student-section {
            display: flex;
            align-items: flex-start;
            justify-content: space-between;
            gap: 15px;
            margin-top: 10px;
        }

        .student-photo {
            width: 80px;
            height: 80px;
            object-fit: cover;
            border-radius: 5px;
            flex-shrink: 0;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
            border: 2px solid #333;
            margin: 10px;
        }

        .student-details {
            flex-shrink: 0;
        }

        .result-header {
            font-size: 8px;
            background-color: #757575 !important;
        }

        .fontwhite {
            color: #FFF !important;
        }

        .result-body {
            font-size: 9px;
            font-weight: bolder;
        }

        .result-body2 {
            font-size: 8px;
            font-weight: normal;
        }

        .result-body3 {
            font-size: 7px;
            font-weight: normal;
        }

        .report-body2 {
            font-size: 9px;
            font-weight: bold;
        }

        .fontnormal {
            font-weight: normal;
        }

        .school-name {
            font-size: 18px;
            font-family: Georgia, "Times New Roman", Times, serif;
            font-weight: bolder;
            margin-bottom: 5px;
        }

        .contacts {
            font-size: 10px;
            font-weight: bold;
            margin-bottom: 3px;
        }

        .bgimage {
            background-image: url(images/signin_feild_bg.gif) !important;
            background-repeat: repeat;
            -webkit-print-color-adjust: exact;
        }

        .summary-cards {
            display: flex;
            gap: 10px;
            margin: 15px 0;
        }

        .summary-card {
            flex: 1;
            text-align: center;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            background-color: #f8f9fa;
        }

        .summary-card h6 {
            margin: 0 0 5px 0;
            font-size: 10px;
            font-weight: bold;
        }

        .summary-card .value {
            font-size: 14px;
            font-weight: bold;
            color: #007bff;
        }

        @media print {
            .no-print {
                display: none;
            }

            body {
                margin: 0;
            }
        }

        /* A4 Portrait Width Constraint */
        .a4-portrait-min {
            min-width: 794px;
        }
    </style>
</head>
<body class="a4-portrait-min">
<div style="width:794px;margin:auto;margin-top:0px;padding:8px;margin-bottom:15px"
     class="bgimage add-border main-container">

    <!-- START OF BANNER DIV -->
    <div class="header-flex">
        <img src="{{ asset('images/rosa-mys-logo.png') }}" alt="school logo" class="school-logo">
        <div class="school-info">
            <div class="school-name">{{ settings('school_name', config('app.name')) }}</div>
            @if(settings('school_address'))
                <div class="contacts">{{ settings('school_address') }}</div>
            @endif
            <div class="contacts">
                @if(settings('school_website'))
                    <i class="fa fa-desktop"></i> {{ settings('school_website') }}
                @endif
                @if(settings('school_email'))
                    @if(settings('school_website')) | @endif
                    <i class="fa fa-envelope"></i> {{ settings('school_email') }}
                @endif
            </div>
            @if(settings('school_phone'))
                <div class="contacts"><i class="fa fa-phone"></i> Phone: {{ settings('school_phone') }}</div>
            @endif
        </div>
    </div>
    <!-- END OF BANNER DIV -->

    <!-- START OF REPORT TITLE DIV -->
    <div class="text-center report-title fontwhite" style="margin-top: 8px;">
        Annual Report
    </div>
    <!-- END OF REPORT TITLE DIV -->

    <!-- START OF DESCRIPTION SECTION DIV -->
    @php
        $helpers = app('App\Services\AnnualResultService')->getCalculationHelpers($data['sessions'], $data['subjects'], $data['studentData']);
        $annualMaxTotal = $helpers['annual_max_total'];
        $correctedAnnualAverage = $helpers['corrected_annual_average'];
        $promotionStatus = $helpers['promotion_status'];
    @endphp
    <div class="student-section">
        <div class="student-details">
            <table class="table-condensed report-body2">
                <tbody>
                <tr>
                    <td><strong>Student ID:</strong> <span
                            class="fontnormal">{{ $data['student']->student_id ?? 'N/A' }}</span></td>
                </tr>
                <tr>
                    <td><strong>Name:</strong> <span class="fontnormal">{{ $data['student']->name }}</span></td>
                </tr>
                <tr>
                    <td>
                        <strong>Academic Year:</strong> <span
                            class="fontnormal">{{ $data['year'] }}/{{ $data['year'] + 1 }}</span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <strong>Gender:</strong> <span
                            class="fontnormal">{{ ucfirst($data['student']->gender ?? 'N/A') }}</span>&nbsp;
                        <strong>Class:</strong> <span class="fontnormal">{{ $data['class']->display_name }}</span>&nbsp;
                        <strong>Remarks:</strong> <span
                            style="color: {{ $promotionStatus['is_promoted'] ? 'green' : 'red' }}">{{ $promotionStatus['remark'] }}</span>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
        <img
            src="{{ $data['student']->profile_photo ? asset('storage/' . $data['student']->profile_photo) : asset('images/user-avatar.png') }}"
            alt="photo" class="student-photo">
    </div>
    <!-- END OF DESCRIPTION SECTION DIV -->

    <!-- SUMMARY CARDS -->
    <div class="summary-cards">
        <div class="summary-card">
            <h6>Annual Total</h6>
            <div class="value">{{ $data['studentData']['annual_grand_total'] }}
                /{{ $annualMaxTotal }}</div>
        </div>
        <div class="summary-card">
            <h6>Annual Score %</h6>
            <div class="value">{{ $correctedAnnualAverage }}%</div>
        </div>
        <div class="summary-card">
            <h6>Terms</h6>
            <div class="value">{{ count($data['sessions']) }}</div>
        </div>
        <div class="summary-card">
            <h6>Comment</h6>
            <div class="value"
                 style="color: {{ $promotionStatus['is_promoted'] ? 'green' : 'red' }}">{{ $promotionStatus['comment'] }}</div>
        </div>
    </div>

    <!-- START OF RESULT SECTION DIV -->
    <div class="row">
        <div class="col-xs-12">
            <table width="99%" border="0" align="left" class="table-condensed table-responsive">
                <tbody>
                <tr>
                    <td align="left" valign="top">
                        <table width="100%" class="table-condensed table-striped table-responsive table-bordered"
                               border="1">
                            <thead>
                            <tr class="result-header">
                                <td rowspan="2" align="center" class="fontwhite">Subject</td>
                                @foreach($data['sessions'] as $session)
                                    <td colspan="4" align="center" class="fontwhite">{{ $session->name }}</td>
                                @endforeach
                            </tr>
                            <tr class="result-header">
                                @foreach($data['sessions'] as $session)
                                    <td align="center" class="fontwhite">CA</td>
                                    <td align="center" class="fontwhite">Exam</td>
                                    <td align="center" class="fontwhite">Total</td>
                                    <td align="center" class="fontwhite">Grade</td>
                                @endforeach
                            </tr>
                            </thead>
                            <tbody class="result-body" style="text-align: center; vertical-align: middle;">
                            @foreach($data['subjects'] as $subject)
                                <tr>
                                    <td nowrap="nowrap"
                                        style="text-align: left;">{{ strtoupper($subject->display_name) }}</td>
                                    @foreach($data['sessions'] as $session)
                                        @php
                                            $result = $data['studentData']['sessions'][$session->id]['subjects'][$subject->id] ?? null;
                                        @endphp
                                        <td>{{ app('App\Services\AnnualResultService')->formatResultValue($result['ca_score'] ?? 0) }}</td>
                                        <td>{{ app('App\Services\AnnualResultService')->formatResultValue($result['exam_score'] ?? 0) }}</td>
                                        <td>{{ app('App\Services\AnnualResultService')->formatResultValue($result['total'] ?? 0) }}</td>
                                        <td>{{ app('App\Services\AnnualResultService')->formatResultValue($result['grade'] ?? 'F') }}</td>
                                    @endforeach
                                </tr>
                            @endforeach
                            <tr style="background-color: #f8f9fa;">
                                <td style="text-align: left;"><strong>Session Total</strong></td>
                                @foreach($data['sessions'] as $session)
                                    <td></td>
                                    <td></td>
                                    @php
                                        $sessionMaxTotal = app('App\Services\AnnualResultService')->calculateSessionMaxTotal($session->id, $data['subjects'], $data['studentData']);
                                    @endphp
                                    <td><strong>{{ $data['studentData']['sessions'][$session->id]['grand_total'] }}/{{ $sessionMaxTotal }}</strong></td>
                                    <td></td>
                                @endforeach
                            </tr>
                            <tr style="background-color: #fff3cd;">
                                <td style="text-align: left;"><strong>Session Average</strong></td>
                                @foreach($data['sessions'] as $session)
                                    <td></td>
                                    <td></td>
                                    <td><strong>{{ $data['studentData']['sessions'][$session->id]['average'] }}</strong></td>
                                    <td></td>
                                @endforeach
                            </tr>
                            </tbody>
                        </table>
                    </td>

                    @if($data['approval'])
                        <td align="left" valign="top" style="padding-left:5px;padding-right:5px">
                            <table width="98%" class="table-condensed table-striped table-responsive table-bordered"
                                   border="1">
                                <thead></thead>
                                <tbody class="result-body3">
                                <tr class="result-header">
                                    <td width="" height="20" align="center" class="fontwhite" nowrap="nowrap">AFFECTIVE
                                        TRAITS
                                    </td>
                                    <td width="39">&nbsp;</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Punctuality</td>
                                    <td align="center" class="">{{ intval($data['approval']->punctuality) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Mental Alertness</td>
                                    <td align="center">{{ intval($data['approval']->mental_alertness) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Attentiveness</td>
                                    <td align="center">{{ intval($data['approval']->attentiveness) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Respect</td>
                                    <td align="center">{{ intval($data['approval']->respect) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Neatness</td>
                                    <td align="center">{{ intval($data['approval']->neatness) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Politeness</td>
                                    <td align="center">{{ intval($data['approval']->politeness) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Honesty</td>
                                    <td align="center">{{ intval($data['approval']->honesty) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Relationship with Peers</td>
                                    <td align="center">{{ intval($data['approval']->relationship_with_peers) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Attitude To School</td>
                                    <td align="center">{{ intval($data['approval']->attitude_to_school) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Spirit of Team Work</td>
                                    <td align="center">{{ intval($data['approval']->teamwork) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Completes School Work Promptly</td>
                                    <td align="center">{{ intval($data['approval']->completes_school_work_promptly) }}</td>
                                </tr>
                                <tr class="result-header">
                                    <td height="20" nowrap="nowrap" class="fontwhite" align="center">&nbsp;&nbsp;&nbsp;PSYCHOMOTOR
                                        SKILLS
                                    </td>
                                    <td align="center">&nbsp;</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Reading</td>
                                    <td align="center">{{ intval($data['approval']->reading) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Verbal Fluency / Diction</td>
                                    <td align="center">{{ intval($data['approval']->verbal_fluency_diction) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Handwriting</td>
                                    <td align="center">{{ intval($data['approval']->handwriting) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Musical Skills</td>
                                    <td align="center">{{ intval($data['approval']->musical_skills) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Creative Arts</td>
                                    <td align="center">{{ intval($data['approval']->creative_arts) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Physical Education</td>
                                    <td align="center">{{ intval($data['approval']->physical_education) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;General Reasoning</td>
                                    <td align="center">{{ intval($data['approval']->general_reasoning) }}</td>
                                </tr>
                                </tbody>
                            </table>
                        </td>
                    @endif
                </tr>
                </tbody>
            </table>
        </div>
    </div>
    <!-- END OF RESULT SECTION DIV -->

    <!-- START OF REPORT SUMMARY SECTION DIV -->
    <div style="display: flex; gap: 10px; margin-top: 10px;">
        <div style="flex: 1;">
            <table width="100%" class="table-condensed table-striped table-responsive table-bordered" border="1">
                <thead>
                <tr class="result-header">
                    <td colspan="2" align="center" class="fontwhite">Annual Summary</td>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td width="60%" nowrap="nowrap" class="result-body"><strong>Annual Total Score</strong></td>

                    <td width="40%" class="result-body2">{{ intval($data['studentData']['annual_grand_total']) }}
                        /{{ intval($annualMaxTotal) }}</td>
                </tr>
                <tr>
                    <td nowrap="nowrap" class="result-body"><strong>Annual Score %</strong></td>
                    <td class="result-body2">{{ $correctedAnnualAverage }}%</td>
                </tr>
                <tr>
                    <td nowrap="nowrap" class="result-body"><strong>Sessions Completed</strong></td>
                    <td class="result-body2">{{ $data['studentData']['session_count'] }}</td>
                </tr>
                <tr>
                    <td nowrap="nowrap" class="result-body"><strong>Total Subjects</strong></td>
                    <td class="result-body2">{{ count($data['subjects']) }}</td>
                </tr>
                @if($data['approval'])
                    <tr>
                        <td nowrap="nowrap" class="result-body"><strong>Head Teacher's Comment</strong></td>
                        <td class="result-body2">{{ $data['approval']->principal_remarks }}</td>
                    </tr>
                @endif
                </tbody>
            </table>
            @if($qrCode)
                <div class="qr-code" style="text-align: center; margin-top: 10px;">
                    {!! $qrCode !!}
                </div>
            @endif
        </div>

        <div style="flex: 1;">
            <table width="100%" class="table-condensed table-striped table-responsive table-bordered" border="1">
                <thead>
                <tr class="result-header">
                    <td colspan="2" align="center" class="fontwhite">Annual Grade Distribution</td>
                </tr>
                </thead>
                <tbody class="result-body">
                <tr>
                    <td width="50%" nowrap="nowrap"><strong>Grade A</strong></td>
                    <td width="50%" class="result-body2">{{ $data['studentData']['annual_grades']['A'] }}</td>
                </tr>
                <tr>
                    <td nowrap="nowrap"><strong>Grade B</strong></td>
                    <td class="result-body2">{{ $data['studentData']['annual_grades']['B'] }}</td>
                </tr>
                <tr>
                    <td nowrap="nowrap"><strong>Grade C</strong></td>
                    <td class="result-body2">{{ $data['studentData']['annual_grades']['C'] }}</td>
                </tr>
                <tr>
                    <td nowrap="nowrap"><strong>Grade D</strong></td>
                    <td class="result-body2">{{ $data['studentData']['annual_grades']['D'] }}</td>
                </tr>
                <tr>
                    <td nowrap="nowrap"><strong>Grade E</strong></td>
                    <td class="result-body2">{{ $data['studentData']['annual_grades']['E'] }}</td>
                </tr>
                <tr>
                    <td><strong>Grade F</strong></td>
                    <td class="result-body2">{{ $data['studentData']['annual_grades']['F'] }}</td>
                </tr>
                </tbody>
            </table>
        </div>

        <div style="flex: 1;">
            @php
                $signatureType = settings('signature_type', 'head_teacher');
                $showProprietor = settings('show_proprietor_signature', false);
                $showHeadTeacher = settings('show_head_teacher_signature', true);
                $proprietorName = settings('proprietor_name', 'School Proprietor');
                $headTeacherName = settings('head_teacher_name', 'Head Teacher');
            @endphp
            @if($signatureType === 'both')
                <div style="display: flex; gap: 10px;">
                    @if($showProprietor)
                        <table width="50%" class="table-condensed table-responsive">
                            <tbody class="result-body">
                            <tr>
                                <td align="center">
                                    <img src="{{ asset('images/proprietor-sign.jpg') }}"
                                         style="width:80px;height:50px;border-radius:5px" alt="proprietor stamp"
                                         class="img-responsive">
                                </td>
                            </tr>
                            <tr>
                                <td align="center" class="fontwhite result-header">{{ $proprietorName }}</td>
                            </tr>
                            <tr>
                                <td align="center" class="fontwhite result-header">Proprietor</td>
                            </tr>
                            <tr>
                                <td align="center" class="fontwhite result-header">{{ config('app.name') }}</td>
                            </tr>
                            </tbody>
                        </table>
                    @endif
                    @if($showHeadTeacher)
                        <table width="50%" class="table-condensed table-responsive">
                            <tbody class="result-body">
                            <tr>
                                <td align="center">
                                    <img src="{{ asset('images/head-teacher-sign.jpg') }}"
                                         style="width:80px;height:50px;border-radius:5px" alt="head teacher stamp"
                                         class="img-responsive">
                                </td>
                            </tr>
                            <tr>
                                <td align="center" class="fontwhite result-header">{{ $headTeacherName }}</td>
                            </tr>
                            <tr>
                                <td align="center" class="fontwhite result-header">Head Teacher</td>
                            </tr>
                            <tr>
                                <td align="center" class="fontwhite result-header">{{ config('app.name') }}</td>
                            </tr>
                            </tbody>
                        </table>
                    @endif
                </div>
            @elseif($signatureType === 'proprietor' && $showProprietor)
                <table width="100%" class="table-condensed table-responsive">
                    <tbody class="result-body">
                    <tr>
                        <td align="center">
                            <img src="{{ asset('images/proprietor-sign.jpg') }}"
                                 style="width:100px;height:60px;border-radius:5px" alt="proprietor stamp"
                                 class="img-responsive">
                        </td>
                    </tr>
                    <tr>
                        <td align="center" class="fontwhite result-header">{{ $proprietorName }}</td>
                    </tr>
                    <tr>
                        <td align="center" class="fontwhite result-header">Proprietor</td>
                    </tr>
                    <tr>
                        <td align="center" class="fontwhite result-header">{{ config('app.name') }}</td>
                    </tr>
                    </tbody>
                </table>
            @elseif($signatureType === 'head_teacher' && $showHeadTeacher)
                <table width="100%" class="table-condensed table-responsive">
                    <tbody class="result-body">
                    <tr>
                        <td align="center">
                            <img src="{{ asset('images/head-teacher-sign.jpg') }}"
                                 style="width:100px;height:60px;border-radius:5px" alt="head teacher stamp"
                                 class="img-responsive">
                        </td>
                    </tr>
                    <tr>
                        <td align="center" class="fontwhite result-header">{{ $headTeacherName }}</td>
                    </tr>
                    <tr>
                        <td align="center" class="fontwhite result-header">Head Teacher</td>
                    </tr>
                    <tr>
                        <td align="center" class="fontwhite result-header">{{ config('app.name') }}</td>
                    </tr>
                    </tbody>
                </table>
            @endif
        </div>
    </div>
    <!-- END OF REPORT SUMMARY SECTION DIV -->



    <!-- Teachers and Timestamp Section -->
    @if(settings('show_class_teachers_on_print', true) || settings('show_timestamp', true))
        <div style="margin-top: 20px; border-top: 1px solid #ccc; padding-top: 10px;">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                @if(settings('show_class_teachers_on_print', true))
                    <div>
                        <strong class="result-body">Class Teachers:</strong>
                        <span class="result-body2">
                    @if($data['teachers'] && $data['teachers']->count() > 0)
                                {{ $data['teachers']->pluck('name')->join(', ') }}
                            @else
                                No teachers assigned
                            @endif
                </span>
                    </div>
                @endif
                @if(settings('show_timestamp', true))
                    <div>
                        <span
                            class="result-body2">Generated on: {{ $data['generated_at']->format('M d, Y \a\t h:i A') }}</span>
                    </div>
                @endif
            </div>
        </div>
    @endif

    <div class="no-print" style="margin-top: 30px;">
        <button class="btn btn-primary" onclick="window.print()">
            <i class="fa fa-print"></i> Print Annual Result
        </button>
        <button class="btn btn-secondary" onclick="window.close()">
            <i class="fa fa-times"></i> Close
        </button>
    </div>
</div>

<script>
    window.addEventListener('load', function() {
        setTimeout(function() {
            window.print();
        }, 500);
    });
</script>
</body>
</html>
