@extends('layouts.school-portal')

@section('title', 'My Annual Result')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <h4 class="mb-sm-0">My Annual Result - {{ $data['year'] }}/{{ $data['year'] + 1 }}</h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @include('results.partials.student-annual-result-display', ['data' => $data])
                </div>
            </div>
            
            <!-- Action Buttons -->
            <div class="text-center mt-4 mb-4">
                <a href="{{ route('student.results.print-annual', $data['year']) }}" 
                   class="btn btn-primary me-2 mb-3" 
                   onclick="window.open(this.href, 'printAnnualResult', 'width=794,height=1123,scrollbars=yes,resizable=yes'); return false;">
                    <i class="fas fa-print me-2"></i>Print Result
                </a>
                <a href="{{ route('student.results.annual') }}" class="btn btn-secondary mb-3">
                    <i class="fas fa-arrow-left me-2"></i>Back
                </a>
            </div>
        </div>
    </div>
</div>
@endsection