@extends('layouts.school-portal')

@section('title', 'My Termly Result')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">My Termly Result - {{ $data['session']->name ?? 'N/A' }}</h4>
                <div class="page-title-right">
                    <a href="{{ route('student.results.print-termly', $data['session']->slug ?? '') }}" 
                       class="btn btn-primary me-2" 
                       onclick="window.open(this.href, 'printResult', 'width=794,height=1123,scrollbars=yes,resizable=yes'); return false;">
                        <i class="fas fa-print me-2"></i>Print Result
                    </a>
                    <a href="{{ route('student.results.download-termly-pdf', $data['session']->slug ?? '') }}" 
                       class="btn btn-info me-2">
                        <i class="fas fa-download me-2"></i>Download PDF
                    </a>
                    <a href="{{ route('student.results.termly') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if($data)
                        @include('results.partials.student-result-display', ['data' => $data, 'qrCode' => $qrCode])
                    @else
                        <div class="text-center py-4">
                            <i class="fas fa-exclamation-triangle fa-3x text-warning mb-3"></i>
                            <h5>Result Not Available</h5>
                            <p class="text-muted">Your result for this session is not yet available.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection