<?php

use App\Models\Result;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\SchoolSessionController;
use App\Http\Controllers\SchoolClassController;
use App\Http\Controllers\BatchController;
use App\Http\Controllers\StudentController;
use App\Http\Controllers\StaffController;
use App\Http\Controllers\SubjectController;
use App\Http\Controllers\ResultController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\PromotionController;
use App\Http\Controllers\PaymentRequestController;
use App\Http\Controllers\AnnouncementController;
use App\Http\Controllers\Student\StudentDashboardController;
use App\Http\Controllers\Student\StudentResultController;
use App\Http\Controllers\Student\StudentPaymentController;
use App\Http\Controllers\Student\StudentProfileController;
use App\Http\Controllers\Staff\StaffProfileController;

Route::get('setup', function () {
    \Illuminate\Support\Facades\Artisan::call('storage:link');
});
Route::get('/', [HomeController::class, 'index'])->name('home');

Route::get('dashboard', [DashboardController::class, 'index'])
    ->middleware(['auth'])
    ->name('dashboard');

Route::get('logout', [AuthController::class, 'logout'])->name('logout');
Route::get('login', [AuthController::class, 'login'])->name('login');

// Admin-only routes
Route::middleware(['auth', 'can:admin'])->group(function () {
    Route::resource('school-sessions', SchoolSessionController::class);
    Route::resource('school-classes', SchoolClassController::class);
    Route::get('school-classes-reorder', [SchoolClassController::class, 'reorder'])->name('school-classes.reorder');

    Route::get('subjects', [SubjectController::class, 'index'])->name('subjects.index');
    Route::get('subjects/create', [SubjectController::class, 'create'])->name('subjects.create');
    Route::get('subjects/assign-classes', [SubjectController::class, 'assignClasses'])->name('subjects.assign-classes');

    Route::get('settings/annual-pass-percentage', [SettingsController::class, 'annualPassPercentage'])->name('settings.annual-pass-percentage');
    Route::get('settings/result-settings', [SettingsController::class, 'resultSettings'])->name('settings.result-settings');
    Route::get('settings/school-officials', [SettingsController::class, 'schoolOfficials'])->name('settings.school-officials');
    Route::get('settings/school-info', [SettingsController::class, 'schoolInfo'])->name('settings.school-info');
});

// Head Teacher and Admin routes
Route::middleware(['auth', 'can:head-teacher'])->group(function () {
    Route::get('batches', [BatchController::class, 'index'])->name('batches.index');
    Route::get('batches/{id}/edit', [BatchController::class, 'edit'])->name('batches.edit');
    Route::get('batches/assign-students', [BatchController::class, 'assignStudents'])->name('batches.assign-students');
});

// Head Teacher and Admin routes
Route::middleware(['auth', 'can:head-teacher'])->group(function () {
    Route::get('staff', [StaffController::class, 'index'])->name('staff.index');
    Route::get('staff/{username}/edit', [StaffController::class, 'edit'])->name('staff.edit');
    Route::get('staff/{username}/profile', [StaffController::class, 'show'])->name('staff.show');
    Route::get('staff/assign-classes', [StaffController::class, 'assignClasses'])->name('staff.assign-classes');
});

// Admin-only batch creation routes
Route::middleware(['auth', 'can:admin'])->group(function () {
    Route::get('batches/create', [BatchController::class, 'create'])->name('batches.create');
});

// Admin-only staff creation routes
Route::middleware(['auth', 'can:admin'])->group(function () {
    Route::get('staff/create', [StaffController::class, 'create'])->name('staff.create');
});

// Head Teacher and Admin routes
Route::middleware(['auth', 'can:head-teacher'])->group(function () {
    Route::get('promotion', [PromotionController::class, 'index'])->name('promotion.index');
    Route::get('promotion/by-class', [PromotionController::class, 'byClass'])->name('promotion.by-class');
    Route::get('promotion/by-batch', [PromotionController::class, 'byBatch'])->name('promotion.by-batch');
    Route::get('promotion/individual', [PromotionController::class, 'individual'])->name('promotion.individual');

    Route::get('announcements', [AnnouncementController::class, 'index'])->name('announcements.index');
    Route::get('announcements/create', [AnnouncementController::class, 'create'])->name('announcements.create');
    Route::get('announcements/{announcement_id}/edit', [AnnouncementController::class, 'edit'])->name('announcements.edit');
});

// Results approval routes (based on settings)
Route::middleware(['auth', 'can:approve-results'])->group(function () {
    Route::get('results/approval', [ResultController::class, 'approval'])->name('results.approval');
    Route::get('results/annual-approval', [ResultController::class, 'annualApproval'])->name('results.annual-approval');
});

// Student management routes (Head Teacher and Admin)
Route::middleware(['auth', 'can:manage-students'])->group(function () {
    Route::get('students', [StudentController::class, 'index'])->name('students.index');
    Route::get('students/create', [StudentController::class, 'create'])->name('students.create');
    Route::get('students/{student_id}/edit', [StudentController::class, 'edit'])->name('students.edit');
    Route::get('students/{student_id}/profile', [StudentController::class, 'show'])->name('students.show');
});

// Results management routes (Teachers, Head Teachers, and Admin)
Route::middleware(['auth', 'can:manage-results'])->group(function () {
    Route::get('results/by-student', [ResultController::class, 'byStudent'])->name('results.by-student');
    Route::get('results/by-class', [ResultController::class, 'byClass'])->name('results.by-class');
    Route::get('results/by-subject', [ResultController::class, 'bySubject'])->name('results.by-subject');
    Route::get('results/offline-upload', [ResultController::class, 'offlineUpload'])->name('results.offline-upload');
    Route::get('results/view-annual-results', [ResultController::class, 'viewAnnualResults'])->name('results.view-annual-results');
    Route::get('results/master-list', [ResultController::class, 'masterList'])->name('results.master-list');
    Route::get('results/view-results', [ResultController::class, 'viewResults'])->name('results.view-results');
    Route::get('results/annual-results', [ResultController::class, 'annualResults'])->name('results.annual-results');
    Route::get('results/annual-master-list', [ResultController::class, 'annualMasterList'])->name('results.annual-master-list');
    Route::get('results/student-annual-result', [ResultController::class, 'studentAnnualResult'])->name('results.student-annual-result');
    Route::get('results/print-student-annual/{student_id}/{year}', [ResultController::class, 'printStudentAnnualResult'])->name('results.print-student-annual');
    Route::get('results/print-class-annual/{class}/{year}/{batch?}', [ResultController::class, 'printClassAnnualResult'])->name('results.print-class-annual');
    Route::get('results/print-annual-master-list/{class}/{year}/{batch?}', [ResultController::class, 'printAnnualMasterList'])->name('results.print-annual-master-list');
    Route::get('results/print-master-list/{session}/{class}/{batch?}', [ResultController::class, 'printMasterList'])->name('results.print-master-list');
    Route::get('results/student/{student}/session/{session}', [ResultController::class, 'viewStudentResult'])->name('results.view-student-result');
    Route::get('results/print-student/{student}/session/{session}', [ResultController::class, 'printStudentResult'])->name('results.print-student-result');
});

// Payment management routes (Bursar and Admin)
Route::middleware(['auth', 'can:manage-payments'])->group(function () {
    Route::get('payment-requests', [PaymentRequestController::class, 'index'])->name('payment-requests.index');
    Route::get('payment-requests/create', [PaymentRequestController::class, 'create'])->name('payment-requests.create');
    Route::get('payment-requests/view-by-target', [PaymentRequestController::class, 'viewByTarget'])->name('payment-requests.view-by-target');
    Route::get('payments-history', [PaymentRequestController::class, 'paymentsHistory'])->name('payments.history');
    Route::get('payments/create', [PaymentRequestController::class, 'createPayment'])->name('payments.create');
    Route::get('payments/{payment}/view', [PaymentRequestController::class, 'viewPayment'])->name('payments.view');

    Route::get('settings/finance', [SettingsController::class, 'finance'])->name('settings.finance');
});

// Payroll management routes (Bursar and Admin)
Route::middleware(['auth', 'can:manage-payments'])->group(function () {
    Route::get('payroll', [\App\Http\Controllers\PayrollController::class, 'index'])->name('payroll.index');
    Route::get('payroll/staff-salaries', [\App\Http\Controllers\PayrollController::class, 'staffSalaries'])->name('payroll.staff-salaries');
    Route::get('payroll/salary-history', [\App\Http\Controllers\PayrollController::class, 'salaryHistory'])->name('payroll.salary-history');
    Route::get('payroll/download/{month}/{year}/{format?}', [\App\Http\Controllers\PayrollController::class, 'downloadPayroll'])->name('payroll.download');
    Route::get('payroll/print/{month}/{year}', [\App\Http\Controllers\PayrollController::class, 'printPayroll'])->name('payroll.print');
    Route::get('payroll/adjustments/{salaryHistory}', [\App\Http\Controllers\PayrollController::class, 'getAdjustments'])->name('payroll.adjustments');
});

// Staff salary history route (for all staff)
Route::middleware(['auth'])->group(function () {
    Route::get('my-salary-history', [\App\Http\Controllers\PayrollController::class, 'mySalaryHistory'])
        ->middleware('check.salary.view')
        ->name('staff.salary-history');

    Route::get('staff/profile', [StaffProfileController::class, 'show'])->name('staff.profile');
});

// Student routes
Route::middleware(['auth', 'can:student'])->group(function () {
    Route::get('student/dashboard', [StudentDashboardController::class, 'index'])->name('student.dashboard');
    Route::get('student/profile', [StudentProfileController::class, 'show'])->name('student.profile');

    Route::get('student/results/termly', [StudentResultController::class, 'termlyResults'])->name('student.results.termly');
    Route::get('student/results/annual', [StudentResultController::class, 'annualResults'])->name('student.results.annual');
    Route::get('student/results/termly/{session:slug}', [StudentResultController::class, 'viewTermlyResult'])->name('student.results.view-termly');
    Route::get('student/results/termly/{session:slug}/print', [StudentResultController::class, 'printTermlyResult'])->name('student.results.print-termly');
    Route::get('student/results/annual/{year}', [StudentResultController::class, 'viewAnnualResult'])->name('student.results.view-annual');
    Route::get('student/results/annual/{year}/print', [StudentResultController::class, 'printAnnualResult'])->name('student.results.print-annual');

    Route::get('student/payments', [StudentPaymentController::class, 'index'])->name('student.payments.index');
    Route::get('student/payments/{paymentRequest}/make-payment', [StudentPaymentController::class, 'makePayment'])->name('student.payments.make-payment');
    Route::get('student/payments/receipt/{payment_id}', [StudentPaymentController::class, 'viewReceipt'])->name('student.payments.receipt');
    Route::get('student/payments/receipt/{payment_id}/print', [StudentPaymentController::class, 'printReceipt'])->name('student.payments.receipt.print');
    Route::get('student/payments/{payment}/receipt', [StudentPaymentController::class, 'viewReceipt'])->name('student.payments.receipt');
});

//require __DIR__ . '/auth.php';
