<?php $__env->startSection('title', 'My Profile'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">My Profile</h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-4">
            <div class="card">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <?php if($student->profile_photo): ?>
                            <img src="<?php echo e(asset('storage/' . $student->profile_photo)); ?>" 
                                 alt="Profile Photo" class="rounded-circle" width="120" height="120">
                        <?php else: ?>
                            <div class="bg-primary rounded-circle d-inline-flex align-items-center justify-content-center" 
                                 style="width: 120px; height: 120px;">
                                <span class="text-white fs-1"><?php echo e($student->initials()); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                    <h5 class="mb-1"><?php echo e($student->name); ?></h5>
                    <p class="text-muted">Student ID: <?php echo e($student->student_id); ?></p>
                    <p class="text-muted"><?php echo e($student->batch->schoolClass->name ?? 'No Class Assigned'); ?></p>
                </div>
            </div>
        </div>

        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title mb-0">Personal Information</h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">First Name</label>
                            <p><?php echo e($student->firstname); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Middle Name</label>
                            <p><?php echo e($student->middlename ?: 'N/A'); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Surname</label>
                            <p><?php echo e($student->surname); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Gender</label>
                            <p><?php echo e(ucfirst($student->gender)); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Date of Birth</label>
                            <p><?php echo e($student->dob ? \Carbon\Carbon::parse($student->dob)->format('M d, Y') : 'N/A'); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Place of Birth</label>
                            <p><?php echo e($student->place_of_birth ?: 'N/A'); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Email</label>
                            <p><?php echo e($student->email ?: 'N/A'); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Phone</label>
                            <p><?php echo e($student->phone ?: 'N/A'); ?></p>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label fw-bold">Address</label>
                            <p><?php echo e($student->address ?: 'N/A'); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h4 class="card-title mb-0">Academic Information</h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Current Class</label>
                            <p><?php echo e($student->batch->schoolClass->name ?? 'Not Assigned'); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Batch</label>
                            <p><?php echo e($student->batch->name ?? 'Not Assigned'); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Admission Date</label>
                            <p><?php echo e($student->admission_date ? \Carbon\Carbon::parse($student->admission_date)->format('M d, Y') : 'N/A'); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Previous School</label>
                            <p><?php echo e($student->previous_school ?: 'N/A'); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h4 class="card-title mb-0">Next of Kin Information</h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Name</label>
                            <p><?php echo e($student->nok_name ?: 'N/A'); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Phone</label>
                            <p><?php echo e($student->nok_phone ?: 'N/A'); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Relationship</label>
                            <p><?php echo e($student->nok_relationship ?: 'N/A'); ?></p>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label fw-bold">Address</label>
                            <p><?php echo e($student->nok_address ?: 'N/A'); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.school-portal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\edu-p\resources\views/student/profile/show.blade.php ENDPATH**/ ?>