<div>
    <div class="row">
        <div class="col-md-6">
            <div class="card border-md-1 border-0 my-3">
                <div class="card-body">
                    <form wire:submit="assign">
                        <div class="mb-3">
                            <label for="selectedClass" class="form-label">Select Class</label>
                            <select wire:model.live="selectedClass" class="form-select <?php $__errorArgs = ['selectedClass'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value="">Choose a class...</option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($class->id); ?>"><?php echo e($class->display_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedClass'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                        
                        <!--[if BLOCK]><![endif]--><?php if($selectedClass): ?>
                            <div class="mb-3">
                                <label for="selectedSubject" class="form-label">Select Subject</label>
                                <select wire:model="selectedSubject" class="form-select <?php $__errorArgs = ['selectedSubject'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <option value="">Choose a subject...</option>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($subject->id); ?>"><?php echo e($subject->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </select>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedSubject'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            
                            <div class="mb-3">
                                <label for="alias" class="form-label">Alias (Optional)</label>
                                <input type="text" wire:model="alias" class="form-control <?php $__errorArgs = ['alias'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       placeholder="Enter custom name for this class">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['alias'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                <div class="form-text">Leave empty to use the subject's original name</div>
                            </div>
                            
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-plus"></i> Assign Subject
                            </button>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <!--[if BLOCK]><![endif]--><?php if($selectedClass && count($assignedSubjects) > 0): ?>
                <div class="card border-md-1 border-0 my-3">
                    <div class="card-header">
                        <h6 class="mb-0">Assigned Subjects</h6>
                    </div>
                    <div class="card-body">
                        <div class="list-group">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $assignedSubjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="list-group-item">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div class="flex-grow-1">
                                            <strong><?php echo e($subject->name); ?></strong>
                                            <!--[if BLOCK]><![endif]--><?php if($subject->schoolClasses->first() && $subject->schoolClasses->first()->pivot->alias): ?>
                                                <br><small class="text-muted">Alias: <?php echo e($subject->schoolClasses->first()->pivot->alias); ?></small>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                        <div class="d-flex gap-1">
                                            <button onclick="openEditAliasModal(<?php echo e($subject->id); ?>, '<?php echo e($subject->name); ?>', '<?php echo e($subject->schoolClasses->first() && $subject->schoolClasses->first()->pivot->alias ? $subject->schoolClasses->first()->pivot->alias : ''); ?>')"
                                                    class="btn btn-outline-primary btn-sm"
                                                    title="<?php echo e($subject->schoolClasses->first() && $subject->schoolClasses->first()->pivot->alias ? 'Edit Alias' : 'Add Alias'); ?>">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <button wire:click="confirmRemove(<?php echo e($subject->id); ?>)"
                                                    class="btn btn-danger btn-sm"
                                                    title="Remove Subject">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>
                </div>
            <?php elseif($selectedClass): ?>
                <div class="card border-md-1 border-0 my-3">
                    <div class="card-body text-center text-muted">
                        No subjects assigned to this class yet.
                    </div>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    </div>

    <!-- Edit Alias Modal -->
    <div class="modal fade" id="editAliasModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-primary">
                    <h5 class="modal-title text-white">Edit Subject Alias</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="editAliasForm">
                        <div class="mb-3">
                            <label class="form-label">Subject Name</label>
                            <input type="text" id="subjectName" class="form-control" readonly>
                        </div>
                        <div class="mb-3">
                            <label for="aliasInput" class="form-label">Alias</label>
                            <input type="text" id="aliasInput" class="form-control" placeholder="Enter alias (optional)">
                            <div class="form-text">Leave empty to use the subject's original name</div>
                        </div>
                        <div class="d-flex justify-content-end gap-2">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            <button type="button" class="btn btn-primary" onclick="saveAlias()">Save Alias</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
    let currentSubjectId = null;

    function openEditAliasModal(subjectId, subjectName, currentAlias) {
        currentSubjectId = subjectId;
        document.getElementById('subjectName').value = subjectName;
        document.getElementById('aliasInput').value = currentAlias;
        
        const modal = new bootstrap.Modal(document.getElementById('editAliasModal'));
        modal.show();
    }

    function saveAlias() {
        const alias = document.getElementById('aliasInput').value;
        
        if (currentSubjectId) {
            window.Livewire.find('<?php echo e($_instance->getId()); ?>').call('saveAlias', currentSubjectId, alias).then(() => {
                const modal = bootstrap.Modal.getInstance(document.getElementById('editAliasModal'));
                modal.hide();
            });
        }
    }
    </script>
</div>
<?php /**PATH C:\wamp64\www\edu-p\resources\views/livewire/assign-subjects-to-classes.blade.php ENDPATH**/ ?>