<div class="result-container">
    <!-- Header Section -->
    <div class="result-header-section mb-3">
        <div class="d-flex align-items-center justify-content-center gap-3">
            <img src="<?php echo e(asset('images/rosa-mys-logo.png')); ?>" alt="school logo" class="school-logo d-none d-md-block">
            <div class="text-center">
                <h5 class="school-name mb-1"><?php echo e(settings('school_name', config('app.name'))); ?></h5>
                <!--[if BLOCK]><![endif]--><?php if(settings('school_address')): ?>
                    <p class="contacts mb-1"><?php echo e(settings('school_address')); ?></p>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                <p class="contacts mb-1">
                    <!--[if BLOCK]><![endif]--><?php if(settings('school_website')): ?>
                        <i class="fa fa-desktop"></i> <?php echo e(settings('school_website')); ?>

                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    <!--[if BLOCK]><![endif]--><?php if(settings('school_email')): ?>
                        <!--[if BLOCK]><![endif]--><?php if(settings('school_website')): ?> | <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <i class="fa fa-envelope"></i> <?php echo e(settings('school_email')); ?>

                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </p>
                <!--[if BLOCK]><![endif]--><?php if(settings('school_phone')): ?>
                    <p class="contacts mb-0"><i class="fa fa-phone"></i> <?php echo e(settings('school_phone')); ?></p>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>
    </div>

    <!-- Report Title -->
    <div class="text-center bg-secondary text-white py-2 mb-3 rounded">
        <h6 class="mb-0 text-light">Termly Report</h6>
    </div>

    <!-- Student Info Section -->
    <div class="row mb-3">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body p-2">
                    <div class="col-12">
                        <div class="mb-2"><strong>Name:</strong> <?php echo e($data['student']->name); ?></div>
                        <div class="mb-2"><strong>Student ID:</strong> <?php echo e($data['student']->student_id ?? 'N/A'); ?></div>
                        <div class="mb-2"><strong>Academic Session:</strong> <?php echo e($data['session']->start_year); ?>/<?php echo e($data['session']->end_year); ?> - <?php echo e($data['session']->name); ?></div>
                        <div class="mb-2"><strong>Next Term Begins:</strong> <?php echo e($data['session']->next_session_start_date ? $data['session']->next_session_start_date->format('M jS, Y') : 'TBA'); ?></div>
                        <div class="mb-2"><strong>Gender:</strong> <?php echo e(ucfirst($data['student']->gender ?? 'N/A')); ?></div>
                        <div class="mb-2"><strong>Class:</strong> <?php echo e($data['class']->display_name ?? $data['class']->name); ?></div>
                        <div class="mb-0"><strong>Remarks:</strong> 
                            <span class="badge <?php echo e($data['studentData']['remark'] === 'Pass' ? 'bg-success' : 'bg-danger'); ?>">
                                <?php echo e($data['studentData']['remark']); ?>

                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4 text-center">
            <img src="<?php echo e($data['student']->profile_photo ? asset('storage/' . $data['student']->profile_photo) : asset('images/user-avatar.png')); ?>" 
                 alt="photo" class="student-photo-responsive">
        </div>
    </div>

    <!-- Results Section -->
    <div class="row">
        <div class="col-12 <?php echo e($data['approval'] ? 'col-lg-8' : ''); ?>">
            <div class="card mb-3">
                <div class="card-header bg-secondary text-white">
                    <h6 class="mb-0 text-light">Subject Results</h6>
                </div>
                <div class="card-body p-0">
                    <!-- Desktop Table -->
                    <div class="d-none d-md-block">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead class="table-dark">
                                    <tr>
                                        <th>Subject</th>
                                        <th class="text-center">CA (40%)</th>
                                        <th class="text-center">Exam (60%)</th>
                                        <th class="text-center">Total (100%)</th>
                                        <th class="text-center">Grade</th>
                                        <th class="text-center">Remarks</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $data['subjects']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $subjectResult = $data['studentData']['subjects'][$subject->id] ?? null;
                                            $caScore = $subjectResult['ca_score'] ?? 0;
                                            $examScore = $subjectResult['exam_score'] ?? 0;
                                            $caAbsent = $subjectResult['ca_absent'] ?? false;
                                            $examAbsent = $subjectResult['exam_absent'] ?? false;
                                            $total = intval($subjectResult['total'] ?? 0);
                                            $grade = $subjectResult['grade'] ?? 'F';
                                            $remark = $total >= 70 ? 'Excellent' : ($total >= 60 ? 'Very Good' : ($total >= 50 ? 'Good' : ($total >= 45 ? 'Average' : ($total >= 40 ? 'Poor' : 'Fail'))));
                                        ?>
                                        <tr>
                                            <td><strong><?php echo e(strtoupper($subject->display_name)); ?></strong></td>
                                            <td class="text-center"><?php echo e($caAbsent ? 'Absent' : intval($caScore)); ?></td>
                                            <td class="text-center"><?php echo e($examAbsent ? 'Absent' : intval($examScore)); ?></td>
                                            <td class="text-center"><strong><?php echo e($total); ?></strong></td>
                                            <td class="text-center"><span class="badge" style="background-color: var(--primary-color);"><?php echo e($grade); ?></span></td>
                                            <td class="text-center"><?php echo e($remark); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Mobile Cards -->
                    <div class="d-md-none">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $data['subjects']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $subjectResult = $data['studentData']['subjects'][$subject->id] ?? null;
                                $caScore = $subjectResult['ca_score'] ?? 0;
                                $examScore = $subjectResult['exam_score'] ?? 0;
                                $caAbsent = $subjectResult['ca_absent'] ?? false;
                                $examAbsent = $subjectResult['exam_absent'] ?? false;
                                $total = intval($subjectResult['total'] ?? 0);
                                $grade = $subjectResult['grade'] ?? 'F';
                                $remark = $total >= 70 ? 'Excellent' : ($total >= 60 ? 'Very Good' : ($total >= 50 ? 'Good' : ($total >= 45 ? 'Average' : ($total >= 40 ? 'Poor' : 'Fail'))));
                            ?>
                            <div class="border-bottom p-2">
                                <div class="row g-1">
                                    <div class="col-12">
                                        <strong><?php echo e(strtoupper($subject->display_name)); ?></strong>
                                    </div>
                                    <div class="col-3">
                                        <small class="text-muted">CA:</small><br>
                                        <strong><?php echo e($caAbsent ? 'Abs' : intval($caScore)); ?></strong>
                                    </div>
                                    <div class="col-3">
                                        <small class="text-muted">Exam:</small><br>
                                        <strong><?php echo e($examAbsent ? 'Abs' : intval($examScore)); ?></strong>
                                    </div>
                                    <div class="col-3">
                                        <small class="text-muted">Total:</small><br>
                                        <strong class="text-primary"><?php echo e($total); ?></strong>
                                    </div>
                                    <div class="col-3">
                                        <small class="text-muted">Grade:</small><br>
                                        <span class="badge" style="background-color: var(--primary-color);"><?php echo e($grade); ?></span>
                                    </div>
                                    <div class="col-12 mt-1">
                                        <small class="text-muted"><?php echo e($remark); ?></small>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
        </div>

        <!--[if BLOCK]><![endif]--><?php if($data['approval']): ?>
            <div class="col-12 col-lg-4">
                <div class="card mb-3">
                    <div class="card-header bg-secondary text-white">
                        <h6 class="mb-0 text-light">Assessment Traits</h6>
                    </div>
                    <div class="card-body p-2">
                        <div class="mb-2">
                            <strong style="color: var(--primary-color);">AFFECTIVE TRAITS</strong>
                        </div>
                        <div class="row g-1 mb-2">
                            <div class="col-8"><small>Punctuality</small></div>
                            <div class="col-4 text-center"><strong><?php echo e(intval($data['approval']->punctuality)); ?></strong></div>
                            <div class="col-8"><small>Mental Alertness</small></div>
                            <div class="col-4 text-center"><strong><?php echo e(intval($data['approval']->mental_alertness)); ?></strong></div>
                            <div class="col-8"><small>Attentiveness</small></div>
                            <div class="col-4 text-center"><strong><?php echo e(intval($data['approval']->attentiveness)); ?></strong></div>
                            <div class="col-8"><small>Respect</small></div>
                            <div class="col-4 text-center"><strong><?php echo e(intval($data['approval']->respect)); ?></strong></div>
                            <div class="col-8"><small>Neatness</small></div>
                            <div class="col-4 text-center"><strong><?php echo e(intval($data['approval']->neatness)); ?></strong></div>
                            <div class="col-8"><small>Politeness</small></div>
                            <div class="col-4 text-center"><strong><?php echo e(intval($data['approval']->politeness)); ?></strong></div>
                            <div class="col-8"><small>Honesty</small></div>
                            <div class="col-4 text-center"><strong><?php echo e(intval($data['approval']->honesty)); ?></strong></div>
                            <div class="col-8"><small>Relationship with Peers</small></div>
                            <div class="col-4 text-center"><strong><?php echo e(intval($data['approval']->relationship_with_peers)); ?></strong></div>
                            <div class="col-8"><small>Attitude To School</small></div>
                            <div class="col-4 text-center"><strong><?php echo e(intval($data['approval']->attitude_to_school)); ?></strong></div>
                            <div class="col-8"><small>Team Work</small></div>
                            <div class="col-4 text-center"><strong><?php echo e(intval($data['approval']->teamwork)); ?></strong></div>
                            <div class="col-8"><small>Completes Work Promptly</small></div>
                            <div class="col-4 text-center"><strong><?php echo e(intval($data['approval']->completes_school_work_promptly)); ?></strong></div>
                        </div>
                        
                        <div class="mb-2">
                            <strong style="color: var(--primary-color);">PSYCHOMOTOR SKILLS</strong>
                        </div>
                        <div class="row g-1">
                            <div class="col-8"><small>Reading</small></div>
                            <div class="col-4 text-center"><strong><?php echo e(intval($data['approval']->reading)); ?></strong></div>
                            <div class="col-8"><small>Verbal Fluency/Diction</small></div>
                            <div class="col-4 text-center"><strong><?php echo e(intval($data['approval']->verbal_fluency_diction)); ?></strong></div>
                            <div class="col-8"><small>Handwriting</small></div>
                            <div class="col-4 text-center"><strong><?php echo e(intval($data['approval']->handwriting)); ?></strong></div>
                            <div class="col-8"><small>Musical Skills</small></div>
                            <div class="col-4 text-center"><strong><?php echo e(intval($data['approval']->musical_skills)); ?></strong></div>
                            <div class="col-8"><small>Creative Arts</small></div>
                            <div class="col-4 text-center"><strong><?php echo e(intval($data['approval']->creative_arts)); ?></strong></div>
                            <div class="col-8"><small>Physical Education</small></div>
                            <div class="col-4 text-center"><strong><?php echo e(intval($data['approval']->physical_education)); ?></strong></div>
                            <div class="col-8"><small>General Reasoning</small></div>
                            <div class="col-4 text-center"><strong><?php echo e(intval($data['approval']->general_reasoning)); ?></strong></div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </div>

    <!-- Summary Section -->
    <div class="row">
        <div class="col-md-6">
            <div class="card mb-3">
                <div class="card-header bg-secondary text-white">
                    <h6 class="mb-0 text-light">Report Summary</h6>
                </div>
                <div class="card-body">
                    <div class="row g-2">
                        <div class="col-12">
                            <strong>Overall Total Score:</strong> <?php echo e(intval($data['studentData']['grand_total'])); ?> out of <?php echo e(count($data['subjects']) * 100); ?>

                        </div>
                        <div class="col-12">
                            <strong>Average Score:</strong> <?php echo e($data['studentData']['average']); ?>%
                        </div>
                        <div class="col-12">
                            <strong>Total Subjects Offered:</strong> <?php echo e(count($data['subjects'])); ?>

                        </div>
                        <!--[if BLOCK]><![endif]--><?php if($data['approval']): ?>
                            <div class="col-12">
                                <strong>Head Teacher's Comment:</strong><br>
                                <em><?php echo e($data['approval']->principal_remarks); ?></em>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card mb-3">
                <div class="card-header bg-secondary text-white">
                    <h6 class="mb-0 text-light">Grading System</h6>
                </div>
                <div class="card-body">
                    <div class="row g-1">
                        <div class="col-6"><strong><?php echo e($data['session']->grade_a_min); ?>% - 100%</strong></div>
                        <div class="col-6">A - Excellent</div>
                        <div class="col-6"><strong><?php echo e($data['session']->grade_b_min); ?>% - <?php echo e($data['session']->grade_a_min - 1); ?>%</strong></div>
                        <div class="col-6">B - Very Good</div>
                        <div class="col-6"><strong><?php echo e($data['session']->grade_c_min); ?>% - <?php echo e($data['session']->grade_b_min - 1); ?>%</strong></div>
                        <div class="col-6">C - Good</div>
                        <div class="col-6"><strong><?php echo e($data['session']->grade_d_min); ?>% - <?php echo e($data['session']->grade_c_min - 1); ?>%</strong></div>
                        <div class="col-6">D - Average</div>
                        <div class="col-6"><strong><?php echo e($data['session']->grade_e_min); ?>% - <?php echo e($data['session']->grade_d_min - 1); ?>%</strong></div>
                        <div class="col-6">E - Poor</div>
                        <div class="col-6"><strong>0% - <?php echo e($data['session']->grade_e_min - 1); ?>%</strong></div>
                        <div class="col-6">F - Fail</div>
                    </div>
                    <hr>
                    <small class="text-muted">
                        CA: Continuous Assessment<br>
                        Avg = Total ÷ Subjects
                    </small>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.result-container {
    font-size: 0.9rem;
}

.school-logo {
    width: auto;
    height: 60px;
    border-radius: 5px;
}

.school-name {
    font-family: Georgia, "Times New Roman", Times, serif;
    font-weight: bold;
    color: var(--primary-color);
}

.contacts {
    font-size: 0.8rem;
    font-weight: 500;
}

.student-photo-responsive {
    width: 100px;
    height: 100px;
    object-fit: cover;
    border-radius: 8px;
    border: 2px solid #dee2e6;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

@media (max-width: 767px) {
    .result-container {
        font-size: 0.8rem;
    }
    
    .school-name {
        font-size: 1.1rem;
    }
    
    .contacts {
        font-size: 0.75rem;
    }
    
    .student-photo-responsive {
        width: 80px;
        height: 80px;
    }
    
    .card-body {
        padding: 0.75rem;
    }
    
    .card-header h6 {
        font-size: 0.9rem;
    }
}

@media (max-width: 576px) {
    .result-container {
        font-size: 0.75rem;
    }
    
    .school-name {
        font-size: 1rem;
    }
    
    .contacts {
        font-size: 0.7rem;
    }
    
    .student-photo-responsive {
        width: 70px;
        height: 70px;
    }
}
</style><?php /**PATH C:\wamp64\www\edu-p\resources\views/results/partials/student-result-display-responsive.blade.php ENDPATH**/ ?>