<div class="container-fluid">

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title mb-0">View Results</h4>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-12 mb-3">
                            <label for="studentSearch" class="form-label">Search Student (Optional)</label>
                            <div class="d-flex gap-2">
                                <input wire:model.live="studentSearch" type="text" id="studentSearch"
                                       class="form-control"
                                       placeholder="Search by name or student ID...">
                                <!--[if BLOCK]><![endif]--><?php if($filteredStudentId): ?>
                                    <button wire:click="clearFilter" class="btn btn-outline-secondary">
                                        <i class="fas fa-times me-1"></i>Clear Filter
                                    </button>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>

                            <!--[if BLOCK]><![endif]--><?php if($filteredStudentId && $selectedStudent): ?>
                                <div class="mt-2 alert alert-info">
                                    <i class="fas fa-filter me-2"></i>Showing results for:
                                    <strong><?php echo e($selectedStudent->name); ?></strong> (<?php echo e($selectedStudent->student_id); ?>)
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            <?php if($studentSearch && !$filteredStudentId): ?>
                                <?php
                                    $searchResults = $this->getStudentsForSearch();
                                ?>

                                <!--[if BLOCK]><![endif]--><?php if($searchResults->count() > 0): ?>
                                    <div class="mt-2 border rounded" style="max-height: 200px; overflow-y: auto;">
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $searchResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="p-2 border-bottom cursor-pointer hover-bg-light"
                                                 wire:click="selectStudent(<?php echo e($student->id); ?>)"
                                                 style="cursor: pointer;"
                                                 onmouseover="this.style.backgroundColor='#f8f9fa'"
                                                 onmouseout="this.style.backgroundColor='white'">
                                                <strong><?php echo e($student->name); ?></strong> (<?php echo e($student->student_id); ?>)
                                                <!--[if BLOCK]><![endif]--><?php if($student->batch && $student->batch->schoolClass): ?>
                                                    <br><small
                                                        class="text-muted"><?php echo e($student->batch->schoolClass->display_name); ?>

                                                        - <?php echo e($student->batch->name); ?></small>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <div class="col-md-6 col-lg-4">
                            <label for="classSelect" class="form-label">Select Class</label>
                            <select wire:model.live="classId" id="classSelect" class="form-select">
                                <option value="">Choose Class...</option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($class->id); ?>"><?php echo e($class->display_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                        </div>
                        <div class="col-md-6 col-lg-4">
                            <label for="batchSelect" class="form-label">Select Batch</label>
                            <select wire:model.live="batchId" id="batchSelect" class="form-select"
                                    wire:key="batch-select-<?php echo e($classId); ?>">
                                <option value="">Choose Batch...</option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($batch->id); ?>"><?php echo e($batch->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                        </div>
                        <div class="col-md-12 col-lg-4">
                            <label for="sessionSelect" class="form-label">Select Session</label>
                            <select wire:model.live="sessionId" id="sessionSelect" class="form-select">
                                <option value="">Choose Session...</option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($session->id); ?>"><?php echo e($session->start_year); ?>

                                        /<?php echo e($session->end_year); ?> - <?php echo e($session->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-12">
                            <button wire:click="loadStudents"
                                    class="btn btn-lg <?php echo e(!$classId || !$batchId || !$sessionId ? 'btn-secondary' : 'btn-primary'); ?> px-4 py-2"
                                    wire:loading.attr="disabled"
                                <?php echo e(!$classId || !$batchId || !$sessionId ? 'disabled' : ''); ?>>
                                <span wire:loading.remove wire:target="loadStudents">
                                    <i class="fas fa-search me-2"></i>Load Students
                                </span>
                                <span wire:loading wire:target="loadStudents">
                                    <i class="fas fa-spinner fa-spin me-2"></i>Loading...
                                </span>
                            </button>
                        </div>
                    </div>

                    <!--[if BLOCK]><![endif]--><?php if($studentsData && count($studentsData) > 0): ?>
                        <!-- Desktop Table -->
                        <div class="d-none d-md-block">
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead class="table-dark">
                                    <tr>
                                        <th>S/N</th>
                                        <th>Student Name</th>
                                        <th>Student ID</th>
                                        <th>Status</th>
                                        <th>Approved By</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $studentsData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($index + 1); ?></td>
                                            <td><?php echo e($data['student']->name); ?></td>
                                            <td><?php echo e($data['student']->student_id ?? 'N/A'); ?></td>
                                            <td>
                                                <!--[if BLOCK]><![endif]--><?php if($data['status'] === 'Approved'): ?>
                                                    <span class="badge bg-success"><?php echo e($data['status']); ?></span>
                                                <?php elseif($data['status'] === 'Pending'): ?>
                                                    <span class="badge bg-warning"><?php echo e($data['status']); ?></span>
                                                <?php else: ?>
                                                    <span class="badge bg-danger"><?php echo e($data['status']); ?></span>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </td>
                                            <td>
                                                <!--[if BLOCK]><![endif]--><?php if($data['approved_by']): ?>
                                                    <div>
                                                        <strong><?php echo e($data['approved_by']); ?></strong><br>
                                                        <small
                                                            class="text-muted"><?php echo e($data['approved_at']->format('M d, Y')); ?></small>
                                                    </div>
                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </td>
                                            <td>
                                                <!--[if BLOCK]><![endif]--><?php if($data['has_results']): ?>
                                                    <button wire:click="viewStudentResult(<?php echo e($data['student']->id); ?>)"
                                                            class="btn btn-sm btn-success me-1">
                                                        <i class="fas fa-eye me-1"></i>View
                                                    </button>
                                                    <a href="<?php echo e(route('results.print-student-result', ['student' => $data['student']->id, 'session' => $sessions->where('id', $sessionId)->first()->slug ?? ''])); ?>"
                                                       class="btn btn-sm btn-primary me-1"
                                                       onclick="window.open(this.href, 'printResult', 'width=794,height=1123,scrollbars=yes,resizable=yes'); return false;">
                                                        <i class="fas fa-print me-1"></i>Print
                                                    </a>
                                                    <!--[if BLOCK]><![endif]--><?php if($data['is_approved'] && $this->canUnapprove()): ?>
                                                        <button
                                                            onclick="confirmUnapprove('<?php echo e($data['student']->id); ?>', '<?php echo e($data['student']->name); ?>')"
                                                            class="btn btn-sm btn-outline-danger">
                                                            <i class="fas fa-times me-1"></i>Unapprove
                                                        </button>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                <?php else: ?>
                                                    <span class="text-muted">No results available</span>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <!-- Mobile Accordions -->
                        <div class="d-md-none">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $studentsData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="card mb-2">
                                    <div class="card-header p-0">
                                        <div class="d-flex">
                                            <div class="flex-grow-1 p-3" data-bs-toggle="collapse" data-bs-target="#student<?php echo e($data['student']->id); ?>" style="cursor: pointer;">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <!-- Mobile view - show only name and number -->
                                                    <div>
                                                        <span class="badge bg-light text-dark me-2"><?php echo e($index + 1); ?></span>
                                                        <strong><?php echo e($data['student']->name); ?></strong>
                                                    </div>
                                                    
                                                    <!-- Mobile chevron -->
                                                    <div>
                                                        <i class="fas fa-chevron-down text-muted" style="transform: rotate(0deg); transition: transform 0.3s ease;"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="collapse" id="student<?php echo e($data['student']->id); ?>">
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <div class="d-flex flex-wrap gap-2 mb-2">
                                                    <span
                                                        class="badge bg-primary">ID: <?php echo e($data['student']->student_id ?? 'N/A'); ?></span>
                                                    <span
                                                        class="badge <?php echo e($data['status'] === 'Approved' ? 'bg-success' : ($data['status'] === 'Pending' ? 'bg-warning' : 'bg-danger')); ?>">
                                                        <?php echo e($data['status']); ?>

                                                    </span>
                                                </div>
                                            </div>
                                            <p><strong>Student ID:</strong> <?php echo e($data['student']->student_id ?? 'N/A'); ?>

                                            </p>
                                            <p><strong>Status:</strong>
                                                <span
                                                    class="badge <?php echo e($data['status'] === 'Approved' ? 'bg-success' : ($data['status'] === 'Pending' ? 'bg-warning' : 'bg-danger')); ?>">
                                                        <?php echo e($data['status']); ?>

                                                    </span>
                                            </p>
                                            <!--[if BLOCK]><![endif]--><?php if($data['approved_by']): ?>
                                                <p><strong>Approved By:</strong> <?php echo e($data['approved_by']); ?></p>
                                                <p><strong>Approved
                                                        On:</strong> <?php echo e($data['approved_at']->format('M d, Y \a\t h:i A')); ?>

                                                </p>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            <!--[if BLOCK]><![endif]--><?php if($data['has_results']): ?>
                                                <div class="d-flex flex-wrap gap-2">
                                                    <button wire:click="viewStudentResult(<?php echo e($data['student']->id); ?>)"
                                                            class="btn btn-sm btn-success">
                                                        <i class="fas fa-eye me-1"></i>View
                                                    </button>
                                                    <a href="<?php echo e(route('results.print-student-result', ['student' => $data['student']->id, 'session' => $sessions->where('id', $sessionId)->first()->slug ?? ''])); ?>"
                                                       class="btn btn-sm btn-primary"
                                                       onclick="window.open(this.href, 'printResult', 'width=794,height=1123,scrollbars=yes,resizable=yes'); return false;">
                                                        <i class="fas fa-print me-1"></i>Print
                                                    </a>
                                                    <!--[if BLOCK]><![endif]--><?php if($data['is_approved'] && $this->canUnapprove()): ?>
                                                        <button
                                                            onclick="confirmUnapprove('<?php echo e($data['student']->id); ?>', '<?php echo e($data['student']->name); ?>')"
                                                            class="btn btn-sm btn-outline-danger">
                                                            <i class="fas fa-times me-1"></i>Unapprove
                                                        </button>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                            <?php else: ?>
                                                <span class="text-muted">No results available</span>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    <?php elseif(is_array($studentsData) && count($studentsData) === 0): ?>
                        <!-- No Approved Results Card -->
                        <div class="card border-warning">
                            <div class="card-body text-center py-5">
                                <i class="fas fa-exclamation-triangle fa-3x text-warning mb-3"></i>
                                <!--[if BLOCK]><![endif]--><?php if($filteredStudentId && $selectedStudent): ?>
                                    <h5 class="card-title text-warning">No Approved Results
                                        for <?php echo e($selectedStudent->name); ?></h5>
                                    <p class="card-text text-muted">
                                        <strong><?php echo e($selectedStudent->name); ?></strong>
                                        (<?php echo e($selectedStudent->student_id); ?>) does not have approved results for the
                                        selected session.
                                        <br>Results need to be approved before they can be viewed here.
                                    </p>
                                <?php else: ?>
                                    <h5 class="card-title text-warning">No Approved Results Found</h5>
                                    <p class="card-text text-muted">
                                        There are no approved results for the selected class, batch, and session.
                                        <br>Results need to be approved before they can be viewed here.
                                    </p>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <div class="mt-3">
                                    <a href="<?php echo e(route('results.approval')); ?>" class="btn btn-primary me-2">
                                        <i class="fas fa-check-circle me-1"></i>Go to Approve Results
                                    </a>
                                    <button wire:click="loadStudents" class="btn btn-outline-secondary">
                                        <i class="fas fa-refresh me-1"></i>Refresh
                                    </button>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <i class="fas fa-users fa-3x text-muted mb-3"></i>
                            <p class="text-muted">Select class, batch, and session to view approved results</p>
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                    <!--[if BLOCK]><![endif]--><?php if($selectedStudentData): ?>
                        <!-- Student Result Modal -->
                        <div class="modal fade show result-modal" style="display: block; background: rgba(0,0,0,0.5);"
                             tabindex="-1">
                            <div class="modal-dialog modal-xl modal-dialog-scrollable modal-fullscreen-md-down">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <span
                                            class="modal-title text-light">Result - <?php echo e($selectedStudentData['student']->name); ?></span>
                                        <button type="button" class="btn-close"
                                                wire:click="closeStudentResult"></button>
                                    </div>
                                    <div class="modal-body p-1 p-md-3">
                                        <?php echo $__env->make('results.partials.student-result-display-responsive', ['data' => $selectedStudentData, 'qrCode' => null], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" wire:click="closeStudentResult">
                                            Close
                                        </button>
                                        <a href="<?php echo e(route('results.print-student-result', ['student' => $selectedStudentData['student']->id, 'session' => $selectedStudentData['session']->slug])); ?>"
                                           class="btn btn-primary"
                                           onclick="window.open(this.href, 'printResult', 'width=794,height=1123,scrollbars=yes,resizable=yes'); return false;">
                                            <i class="fas fa-print me-1"></i>Print Result
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function confirmUnapprove(studentId, studentName) {
        Swal.fire({
            title: 'Remove Approval?',
            text: `Are you sure you want to remove the approval for ${studentName}?`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: 'var(--primary-color)',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, Remove Approval',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').call('unapproveResult', studentId);
            }
        });
    }
    
    document.addEventListener('shown.bs.collapse', function (e) {
        const chevron = e.target.previousElementSibling.querySelector('.fa-chevron-down');
        if (chevron) chevron.style.transform = 'rotate(180deg)';
    });
    
    document.addEventListener('hidden.bs.collapse', function (e) {
        const chevron = e.target.previousElementSibling.querySelector('.fa-chevron-down');
        if (chevron) chevron.style.transform = 'rotate(0deg)';
    });

</script>
<?php /**PATH C:\wamp64\www\edu-p\resources\views/livewire/results/view-results.blade.php ENDPATH**/ ?>