<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Master List - <?php echo e($data['session']->name); ?> <?php echo e($data['session']->start_year); ?>/<?php echo e($data['session']->end_year); ?></title>
    <link href="<?php echo e(asset('vendor/bootstrap-5.3.7.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('vendor/fontawesome-6.7.2/css/all.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/school-portal.css')); ?>" rel="stylesheet">
    <style>
        @page {
            size: A4 landscape;
            margin: 0.3in;
        }

        .report-title {
            font-size: 12px;
            font-style: italic;
            font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
            height: 25px;
            padding-top: 5px;
            margin-top: 0px;
            background-color: #757575 !important;
        }

        .add-border {
            border: 1px solid #CCC;
        }

        .header-flex {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 15px;
        }

        .school-logo {
            width: auto;
            height: 60px;
            border-radius: 5px;
            flex-shrink: 0;
        }

        .school-info {
            text-align: center;
        }

        .result-header {
            font-size: 8px;
            background-color: #757575 !important;
            padding: 2px !important;
        }
        
        .result-header.fontwhite {
            background-color: #757575 !important;
            color: #FFF !important;
        }

        .fontwhite {
            color: #FFF !important;
        }

        .result-body {
            font-size: 7px;
            font-weight: bolder;
            padding: 2px !important;
        }

        .result-body2 {
            font-size: 6px;
            font-weight: normal;
        }

        .report-body2 {
            font-size: 8px;
            font-weight: bold;
        }

        .fontnormal {
            font-weight: normal;
        }

        .school-name {
            font-size: 14px;
            font-family: Georgia, "Times New Roman", Times, serif;
            font-weight: bolder;
            margin-bottom: 3px;
        }

        .contacts {
            font-size: 8px;
            font-weight: bold;
            margin-bottom: 2px;
        }

        .bgimage {
            background-image: url(images/signin_feild_bg.gif) !important;
            background-repeat: repeat;
            -webkit-print-color-adjust: exact;
        }

        @media print {
            .no-print {
                display: none;
            }

            body {
                margin: 0;
            }
        }
    </style>
</head>
<body>

<div class="container-fluid p-2 bgimage add-border main-container">
    <!-- Header -->
    <div class="header-flex">
        <img src="<?php echo e(asset('images/rosa-mys-logo.png')); ?>" alt="school logo" class="school-logo">
        <div class="school-info">
            <div class="school-name"><?php echo e($data['school_info']['name']); ?></div>
            <?php if($data['school_info']['address']): ?>
            <div class="contacts"><?php echo e($data['school_info']['address']); ?></div>
            <?php endif; ?>
            <div class="contacts">
                <?php if($data['school_info']['website']): ?>
                    <i class="fa fa-desktop"></i> <?php echo e($data['school_info']['website']); ?>

                <?php endif; ?>
                <?php if($data['school_info']['website'] && $data['school_info']['email']): ?> | <?php endif; ?>
                <?php if($data['school_info']['email']): ?>
                    <i class="fa fa-envelope"></i> <?php echo e($data['school_info']['email']); ?>

                <?php endif; ?>
            </div>
            <?php if($data['school_info']['phone_1'] || $data['school_info']['phone_2']): ?>
            <div class="contacts">
                <i class="fa fa-phone"></i> Phone: 
                <?php echo e($data['school_info']['phone_1']); ?>

                <?php if($data['school_info']['phone_1'] && $data['school_info']['phone_2']): ?> , <?php endif; ?>
                <?php echo e($data['school_info']['phone_2']); ?>

            </div>
            <?php endif; ?>
        </div>
        <div class="qr-code" style="flex-shrink: 0;">
            <?php echo $qrCode; ?>

        </div>
    </div>

    <!-- Title -->
    <div class="text-center report-title" style="margin-top: 8px; color: white;">
        Termly Master List - <?php echo e($data['session']->name); ?>

    </div>

    <!-- Description -->
    <div style="margin-top: 10px;">
        <table class="table-condensed report-body2">
            <tbody>
            <tr>
                <td><strong>Class:</strong> <span class="fontnormal"><?php echo e($data['class']->display_name); ?><?php if($data['batch']): ?> - <?php echo e($data['batch']->name); ?><?php else: ?><?php endif; ?></span></td>
                <td><strong>Session:</strong> <span class="fontnormal"><?php echo e($data['session']->start_year); ?>/<?php echo e($data['session']->end_year); ?></span></td>
                <td><strong>Term:</strong> <span class="fontnormal"><?php echo e($data['session']->name); ?></span></td>
                <td><strong>Total Possible Score:</strong> <span class="fontnormal"><?php echo e(count($data['subjects']) * 100); ?></span></td>
            </tr>
            </tbody>
        </table>
    </div>

    <!-- Results Table -->
    <div class="table-responsive">
        <table class="table table-condensed table-striped table-bordered" style="min-width: 100%; font-size: 0.7rem;">
                <thead>
                <tr class="result-header">
                    <td rowspan="2" align="center">Pos</td>
                    <td rowspan="2" align="center">Student Name</td>
                    <td rowspan="2" align="center">Student ID</td>
                    <?php $__currentLoopData = $data['subjects']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td colspan="3" align="center"><?php echo e($subject->display_name); ?></td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <td rowspan="2" align="center">Grand Total</td>
                    <td rowspan="2" align="center">Average</td>
                    <td colspan="6" align="center">Grades</td>
                    <td rowspan="2" align="center">Remark</td>
                </tr>
                <tr class="result-header">
                    <?php $__currentLoopData = $data['subjects']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td align="center">CA</td>
                        <td align="center">Ex</td>
                        <td align="center">Tot</td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <td align="center">A</td>
                    <td align="center">B</td>
                    <td align="center">C</td>
                    <td align="center">D</td>
                    <td align="center">E</td>
                    <td align="center">F</td>
                </tr>
                </thead>
                <tbody class="result-body" style="text-align: center; vertical-align: middle;">
                <?php $__currentLoopData = $data['masterListData']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $studentData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><strong><?php echo e($studentData['position_suffix']); ?></strong></td>
                        <td nowrap="nowrap" style="text-align: left;"><strong><?php echo e(strtoupper($studentData['student']->name)); ?></strong></td>
                        <td><strong><?php echo e($studentData['student']->student_id); ?></strong></td>
                        <?php $__currentLoopData = $data['subjects']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php 
                                $subjectResult = $studentData['subjects'][$subject->id] ?? null;
                                $isLastSubject = $loop->last;
                            ?>
                            <td><?php echo e(intval($subjectResult['ca_score'] ?? 0)); ?></td>
                            <td><?php echo e(intval($subjectResult['exam_score'] ?? 0)); ?></td>
                            <td style="<?php echo e($isLastSubject ? 'border-right: 3px solid #000;' : ''); ?>"><?php echo e(intval($subjectResult['total'] ?? 0)); ?></td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <td><strong><?php echo e(intval($studentData['grand_total'])); ?></strong></td>
                        <td><strong><?php echo e($studentData['average']); ?></strong></td>
                        <td><?php echo e($studentData['grades']['A']); ?></td>
                        <td><?php echo e($studentData['grades']['B']); ?></td>
                        <td><?php echo e($studentData['grades']['C']); ?></td>
                        <td><?php echo e($studentData['grades']['D']); ?></td>
                        <td><?php echo e($studentData['grades']['E']); ?></td>
                        <td><?php echo e($studentData['grades']['F']); ?></td>
                        <td style="color: <?php echo e($studentData['remark'] === 'Pass' ? 'green' : 'red'); ?>"><strong><?php echo e($studentData['remark']); ?></strong></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
    </div>

    <!-- Teachers and Timestamp Section -->
    <div style="margin-top: 20px; border-top: 1px solid #ccc; padding-top: 10px;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <div>
                <strong class="result-body">Class Teachers:</strong>
                <span class="result-body2">
                    <?php if($data['class']->teachers->count() > 0): ?>
                        <?php echo e($data['class']->teachers->pluck('name')->join(', ')); ?>

                    <?php else: ?>
                        No teachers assigned
                    <?php endif; ?>
                </span>
            </div>
            <?php
                $signatureType = settings('signature_type', 'head_teacher');
                $showProprietor = settings('show_proprietor_signature', false);
                $showHeadTeacher = settings('show_head_teacher_signature', true);
                $proprietorName = settings('proprietor_name', 'School Proprietor');
                $headTeacherName = settings('head_teacher_name', 'Head Teacher');
            ?>
            <?php if($signatureType === 'both'): ?>
                <div style="text-align: center; display: flex; gap: 20px; justify-content: center;">
                    <?php if($showProprietor): ?>
                    <div>
                        <img src="<?php echo e(asset('images/proprietor-sign.jpg')); ?>" style="width:70px;height:35px;border-radius:3px" alt="proprietor signature" class="img-responsive">
                        <div class="result-body2" style="margin-top: 3px;"><?php echo e($proprietorName); ?></div>
                        <div class="result-body2">Proprietor</div>
                        <div class="result-body2"><?php echo e($data['school_info']['name']); ?></div>
                    </div>
                    <?php endif; ?>
                    <?php if($showHeadTeacher): ?>
                    <div>
                        <img src="<?php echo e(asset('images/head-teacher-sign.jpg')); ?>" style="width:70px;height:35px;border-radius:3px" alt="head teacher signature" class="img-responsive">
                        <div class="result-body2" style="margin-top: 3px;"><?php echo e($headTeacherName); ?></div>
                        <div class="result-body2">Head Teacher</div>
                        <div class="result-body2"><?php echo e($data['school_info']['name']); ?></div>
                    </div>
                    <?php endif; ?>
                </div>
            <?php elseif($signatureType === 'proprietor' && $showProprietor): ?>
                <div style="text-align: center;">
                    <img src="<?php echo e(asset('images/proprietor-sign.jpg')); ?>" style="width:80px;height:40px;border-radius:3px" alt="proprietor signature" class="img-responsive">
                    <div class="result-body2" style="margin-top: 3px;"><?php echo e($proprietorName); ?></div>
                    <div class="result-body2">Proprietor</div>
                    <div class="result-body2"><?php echo e($data['school_info']['name']); ?></div>
                </div>
            <?php elseif($signatureType === 'head_teacher' && $showHeadTeacher): ?>
                <div style="text-align: center;">
                    <img src="<?php echo e(asset('images/head-teacher-sign.jpg')); ?>" style="width:80px;height:40px;border-radius:3px" alt="head teacher signature" class="img-responsive">
                    <div class="result-body2" style="margin-top: 3px;"><?php echo e($headTeacherName); ?></div>
                    <div class="result-body2">Head Teacher</div>
                    <div class="result-body2"><?php echo e($data['school_info']['name']); ?></div>
                </div>
            <?php endif; ?>
            <div>
                <span class="result-body2">Generated on: <?php echo e(now()->format('M d, Y \a\t h:i A')); ?></span>
            </div>
        </div>
    </div>
</div>

<div class="no-print" style="margin-top: 30px; text-align: center;">
    <button class="btn btn-primary" onclick="window.print()">
        <i class="fa fa-print"></i> Print Master List
    </button>
    <button class="btn btn-secondary" onclick="window.close()">
        <i class="fa fa-times"></i> Close
    </button>
</div>

</body>
</html><?php /**PATH C:\wamp64\www\edu-p\resources\views/results/print-master-list.blade.php ENDPATH**/ ?>