<div>
    <div class="row mb-3">
        <div class="col-md-6">
            <input type="text" wire:model.live="search" class="form-control" placeholder="Search subjects...">
        </div>
    </div>

    <div class="d-none d-md-block">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Classes Assigned</th>
                    <th>Actions</th>
                </tr>
                </thead>
                <tbody>
                <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($subjects->firstItem() + $index); ?></td>
                        <td>
                            <!--[if BLOCK]><![endif]--><?php if($editingSubject && $editingSubject->id === $subject->id): ?>
                                <input type="text" wire:model="name" class="form-control form-control-sm">
                            <?php else: ?>
                                <?php echo e($subject->name); ?>

                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </td>
                        <td><?php echo e($subject->schoolClasses->count()); ?></td>
                        <td>
                            <!--[if BLOCK]><![endif]--><?php if($editingSubject && $editingSubject->id === $subject->id): ?>
                                <button wire:click="update" class="btn btn-success btn-sm me-2">
                                    <i class="fas fa-check"></i>
                                </button>
                                <button wire:click="cancelEdit" class="btn btn-secondary btn-sm">
                                    <i class="fas fa-times"></i>
                                </button>
                            <?php else: ?>
                                <button wire:click="edit(<?php echo e($subject->id); ?>)" class="btn btn-primary btn-sm me-2">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button wire:click="confirmDelete(<?php echo e($subject->id); ?>)"
                                        class="btn btn-danger btn-sm">
                                    <i class="fas fa-trash"></i>
                                </button>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="4" class="text-center">No subjects found.</td>
                    </tr>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </tbody>
            </table>
        </div>
    </div>

    <div class="d-md-none">
        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="accordion mb-2" id="subject-<?php echo e($subject->id); ?>" wire:ignore.self>
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button
                            class="accordion-button <?php echo e($editingSubject && $editingSubject->id === $subject->id ? '' : 'collapsed'); ?> d-flex align-items-center"
                            type="button"
                            data-bs-toggle="collapse" data-bs-target="#collapse-<?php echo e($subject->id); ?>"
                            onclick="toggleChevron('subject-<?php echo e($subject->id); ?>')">
                            <div class="flex-grow-1">
                                <div class="fw-bold"><?php echo e($subjects->firstItem() + $index); ?>. <?php echo e($subject->name); ?></div>
                            </div>
                            <i class="fas fa-chevron-down accordion-chevron ms-2"></i>
                        </button>
                    </h2>
                    <div id="collapse-<?php echo e($subject->id); ?>"
                         class="accordion-collapse collapse <?php echo e($editingSubject && $editingSubject->id === $subject->id ? 'show' : ''); ?>">
                        <div class="accordion-body">
                            <!--[if BLOCK]><![endif]--><?php if($editingSubject && $editingSubject->id === $subject->id): ?>
                                <div class="mb-3">
                                    <label class="form-label">Subject Name</label>
                                    <input type="text" wire:model="name" class="form-control form-control-sm">
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <div class="row g-2 mb-3">
                                <div class="col-12">
                                    <small class="text-muted">Classes Assigned</small>
                                    <div><?php echo e($subject->schoolClasses->count()); ?></div>
                                </div>
                            </div>
                            <div class="d-flex gap-2 flex-wrap">
                                <!--[if BLOCK]><![endif]--><?php if($editingSubject && $editingSubject->id === $subject->id): ?>
                                    <button wire:click="update" class="btn btn-success btn-sm"
                                            onclick="event.stopPropagation()">
                                        <i class="fas fa-check me-2"></i>Save
                                    </button>
                                    <button wire:click="cancelEdit" class="btn btn-secondary btn-sm"
                                            onclick="event.stopPropagation()">
                                        <i class="fas fa-times me-2"></i>Cancel
                                    </button>
                                <?php else: ?>
                                    <button wire:click="edit(<?php echo e($subject->id); ?>)" class="btn btn-primary btn-sm"
                                            onclick="event.stopPropagation()">
                                        <i class="fas fa-edit me-2"></i>Edit
                                    </button>
                                    <button wire:click="confirmDelete(<?php echo e($subject->id); ?>)" class="btn btn-danger btn-sm"
                                            onclick="event.stopPropagation()">
                                        <i class="fas fa-trash me-2"></i>Delete
                                    </button>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <p class="text-center">No subjects found.</p>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </div>

    <?php echo e($subjects->links('custom.pagination')); ?>

</div>


<?php /**PATH C:\wamp64\www\edu-p\resources\views/livewire/subjects-list.blade.php ENDPATH**/ ?>