<div>
    <!-- Search Row -->
    <div class="row mb-2">
        <div class="col-12">
            <input type="text" class="form-control" placeholder="Search students..." wire:model.live="search">
        </div>
    </div>
    
    <!-- Filters Row -->
    <div class="row mb-3">
        <div class="col-lg-2 col-md-6 col-sm-6 mb-2">
            <select class="form-select" wire:model.live="classFilter">
                <option value="">All Classes</option>
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($class->id); ?>"><?php echo e($class->display_name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            </select>
        </div>
        <div class="col-lg-2 col-md-6 col-sm-6 mb-2">
            <select class="form-select" wire:model.live="batchFilter">
                <option value="">All Batches</option>
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($batch->id); ?>"><?php echo e($batch->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            </select>
        </div>
        <div class="col-lg-2 col-md-6 col-sm-6 mb-2">
            <select class="form-select" wire:model.live="statusFilter">
                <option value="">All Status</option>
                <option value="active">Active</option>
                <option value="inactive">Inactive</option>
                <option value="graduated">Graduated</option>
            </select>
        </div>
        <div class="col-lg-6 col-md-6 col-sm-6 mb-2">
            <select class="form-select" wire:model.live="perPage">
                <option value="5">5 per page</option>
                <option value="10">10 per page</option>
                <option value="25">25 per page</option>
                <option value="50">50 per page</option>
            </select>
        </div>
    </div>

    <!-- Students Accordions -->
    <div>
        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="card mb-2">
                <div class="card-header p-0">
                    <div class="d-flex">
                        <div class="flex-grow-1 p-3" data-bs-toggle="collapse"
                             data-bs-target="#student<?php echo e($student->id); ?>" style="cursor: pointer;">
                            <div class="d-flex justify-content-between align-items-center">
                                <!-- Desktop and Medium screen view - show name and ID -->
                                <div class="d-none d-md-block">
                                    <span class="badge bg-light text-dark me-2"><?php echo e($students->firstItem() + $index); ?></span>
                                    <strong><?php echo e($student->name); ?></strong>
                                    <span class="text-muted ms-2">|</span>
                                    <strong class="ms-2">ID:</strong> <?php echo e($student->student_id); ?>

                                </div>
                                
                                <!-- Mobile view - show only name and number -->
                                <div class="d-md-none">
                                    <span class="badge bg-light text-dark me-2"><?php echo e($students->firstItem() + $index); ?></span>
                                    <strong><?php echo e($student->name); ?></strong>
                                </div>
                                
                                <!-- Chevron for all screen sizes -->
                                <div>
                                    <i class="fas fa-chevron-down text-muted"></i>
                                </div>
                            </div>
                        </div>
                        <div class="p-3 border-start">
                            <div class="dropdown">
                                <button class="btn btn-sm btn-outline-secondary" type="button"
                                        data-bs-toggle="dropdown">
                                    <i class="fas fa-bars"></i>
                                </button>
                                <ul class="dropdown-menu dropdown-menu-sm">
                                    <li><a class="dropdown-item dropdown-item-sm"
                                           href="<?php echo e(route('students.show', $student->student_id)); ?>">
                                            <i class="fas fa-eye me-2"></i>View Profile
                                        </a></li>
                                    <li><a class="dropdown-item dropdown-item-sm"
                                           href="<?php echo e(route('students.edit', $student->student_id)); ?>">
                                            <i class="fas fa-edit me-2"></i>Edit
                                        </a></li>
                                    <li>
                                        <hr class="dropdown-divider">
                                    </li>
                                    <li>
                                        <button class="dropdown-item dropdown-item-sm text-warning"
                                                onclick="confirmToggleStatus('<?php echo e($student->id); ?>', '<?php echo e($student->name); ?>')">
                                            <i class="fas fa-ban me-2"></i><?php echo e($student->active ? 'Deactivate' : 'Activate'); ?>

                                        </button>
                                    </li>
                                    <li>
                                        <hr class="dropdown-divider">
                                    </li>
                                    <li>
                                        <button class="dropdown-item dropdown-item-sm text-danger"
                                                onclick="confirmDelete('<?php echo e($student->id); ?>', '<?php echo e($student->name); ?>')">
                                            <i class="fas fa-trash me-2"></i>Delete
                                        </button>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="collapse" id="student<?php echo e($student->id); ?>">
                    <div class="card-body">
                        <!-- Status info for all screen sizes -->
                        <div class="mb-3">
                            <div class="d-flex flex-wrap gap-2 mb-2">
                                <span class="badge bg-primary">ID: <?php echo e($student->student_id); ?></span>
                                <!--[if BLOCK]><![endif]--><?php if($student->batch && $student->batch->schoolClass): ?>
                                    <span class="badge bg-primary"><?php echo e($student->batch->schoolClass->display_name); ?></span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">No Class</span>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <!--[if BLOCK]><![endif]--><?php if($student->batch): ?>
                                    <span class="badge bg-info"><?php echo e($student->batch->name); ?></span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">No Batch</span>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <!--[if BLOCK]><![endif]--><?php if($student->batch && $student->batch->graduated): ?>
                                    <span class="badge bg-info">Graduated</span>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <!--[if BLOCK]><![endif]--><?php if($student->active): ?>
                                    <span class="badge bg-success">Active</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">Inactive</span>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-3 text-center mb-3">
                                <!--[if BLOCK]><![endif]--><?php if($student->profile_photo): ?>
                                    <img src="<?php echo e(asset('storage/' . $student->profile_photo)); ?>" alt="<?php echo e($student->name); ?>" 
                                         class="img-thumbnail rounded" style="width: 120px; height: 120px; object-fit: cover;" loading="lazy">
                                <?php else: ?>
                                    <div class="bg-light border rounded d-inline-flex align-items-center justify-content-center" 
                                         style="width: 120px; height: 120px;">
                                        <i class="fas fa-user text-muted" style="font-size: 45px;"></i>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="col-md-4">
                                <p><strong>Student ID:</strong> <code><?php echo e($student->student_id); ?></code></p>
                                <p><strong>Email:</strong> <?php echo e($student->email ?: 'N/A'); ?></p>
                                <p><strong>Phone:</strong> <?php echo e($student->phone ?: 'N/A'); ?></p>
                                <p><strong>Date of Birth:</strong> <?php echo e($student->dob ? \Carbon\Carbon::parse($student->dob)->format('M d, Y') : 'N/A'); ?></p>
                            </div>
                            <div class="col-md-5">
                                <p><strong>Class:</strong> <?php echo e($student->batch->schoolClass->display_name ?? 'Not Assigned'); ?></p>
                                <p><strong>Batch:</strong> <?php echo e($student->batch->name ?? 'Not Assigned'); ?></p>
                                <p><strong>Admission Date:</strong> <?php echo e($student->admission_date ? \Carbon\Carbon::parse($student->admission_date)->format('M d, Y') : 'N/A'); ?></p>
                                <p><strong>Next of Kin:</strong> <?php echo e($student->nok_name ?: 'N/A'); ?></p>
                                <p><strong>NOK Phone:</strong> <?php echo e($student->nok_phone ?: 'N/A'); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-center py-4">
                <p>No students found</p>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </div>

    <!-- Pagination -->
    <div class="d-flex justify-content-center">
        <?php echo e($students->links('custom.pagination')); ?>

    </div>
</div>

<script>
    function confirmToggleStatus(studentId, studentName) {
        Swal.fire({
            title: 'Toggle Student Status?',
            text: `Are you sure you want to change ${studentName}'s access status?`,
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: 'var(--primary-color)',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, Change Status',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').
                toggleStudentStatus(studentId);
            }
        });
    }

    function confirmDelete(studentId, studentName) {
        Swal.fire({
            title: 'Delete Student?',
            text: `Are you sure you want to delete ${studentName}? This action cannot be undone.`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc3545',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, Delete',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').
                deleteStudent(studentId);
            }
        });
    }
</script>
<?php /**PATH C:\wamp64\www\edu-p\resources\views/livewire/students-table.blade.php ENDPATH**/ ?>