<div>
    <div class="card">
        <div class="card-header">
            <h5>My Salary History</h5>
        </div>
        <div class="card-body">
            <!--[if BLOCK]><![endif]--><?php if(auth()->user()->monthly_salary): ?>
            <div class="alert alert-info mb-4">
                <strong>Current Monthly Salary:</strong> ₦<?php echo e(number_format(auth()->user()->monthly_salary, 0)); ?>

            </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Period</th>
                            <th>Base Salary</th>
                            <th>Bonus</th>
                            <th>Deductions</th>
                            <th>Net Salary</th>
                            <th>Status</th>
                            <th>Paid Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $salaryHistories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $salary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($salary->month_year); ?></td>
                            <td>₦<?php echo e(number_format($salary->monthly_salary, 0)); ?></td>
                            <td>
                                ₦<?php echo e(number_format($salary->total_bonus, 0)); ?>

                            </td>
                            <td>
                                ₦<?php echo e(number_format($salary->total_deductions, 0)); ?>

                            </td>
                            <td>
                                <strong>₦<?php echo e(number_format($salary->net_salary, 0)); ?></strong>
                                <!--[if BLOCK]><![endif]--><?php if($salary->adjustments->count() > 0): ?>
                                    <i class="fas fa-info-circle text-dark ms-1" style="cursor: pointer;" data-bs-toggle="collapse" data-bs-target="#adjustments-<?php echo e($salary->id); ?>"></i>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </td>
                            <td>
                                <span class="badge bg-<?php echo e($salary->status === 'paid' ? 'success' : ($salary->status === 'cancelled' ? 'danger' : 'warning')); ?>">
                                    <?php echo e(ucfirst($salary->status)); ?>

                                </span>
                            </td>
                            <td><?php echo e($salary->paid_at ? $salary->paid_at->format('M d, Y') : '-'); ?></td>
                        </tr>
                        <!--[if BLOCK]><![endif]--><?php if($salary->adjustments->count() > 0): ?>
                        <tr>
                            <td colspan="7" class="p-0">
                                <div class="collapse" id="adjustments-<?php echo e($salary->id); ?>">
                                    <div class="card card-body m-2">
                                        <h6>Salary Adjustments</h6>
                                        <div class="table-responsive">
                                            <table class="table table-sm">
                                                <thead>
                                                    <tr>
                                                        <th>Type</th>
                                                        <th>Amount</th>
                                                        <th>Reason</th>
                                                        <th>Date</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $salary->adjustments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $adjustment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td>
                                                            <span class="badge bg-<?php echo e($adjustment->type === 'bonus' ? 'success' : 'danger'); ?>">
                                                                <?php echo e(ucfirst($adjustment->type)); ?>

                                                            </span>
                                                        </td>
                                                        <td>₦<?php echo e(number_format($adjustment->amount, 0)); ?></td>
                                                        <td><?php echo e($adjustment->reason); ?></td>
                                                        <td><?php echo e($adjustment->created_at->format('M d, Y')); ?></td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center text-muted">No salary history found</td>
                        </tr>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </tbody>
                </table>
            </div>
            
            <?php echo e($salaryHistories->links()); ?>

        </div>
    </div>
</div><?php /**PATH C:\wamp64\www\edu-p\resources\views/livewire/staff-salary-dashboard.blade.php ENDPATH**/ ?>