<?php $__env->startSection('title', 'Subjects'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center d-sm-flex">
                        <h5 class="mb-0">Subjects Management</h5>
                        <button class="btn btn-primary btn-sm d-none d-sm-flex align-items-center" data-bs-toggle="modal" data-bs-target="#createSubjectModal">
                            <i class="fas fa-plus me-2"></i>Add Subject
                        </button>
                    </div>
                    <div class="d-sm-none mt-2 text-end">
                        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#createSubjectModal">
                            <i class="fas fa-plus me-2"></i>Add Subject
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Desktop Tab Navigation -->
                    <ul class="nav nav-tabs d-none d-md-flex mb-4" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active text-primary" id="active-subjects-tab" data-bs-toggle="tab" 
                                    data-bs-target="#active-subjects" type="button" role="tab" 
                                    aria-controls="active-subjects" aria-selected="true">
                                <i class="fas fa-book me-2"></i>Active Subjects
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link text-muted" id="archived-subjects-tab" data-bs-toggle="tab" 
                                    data-bs-target="#archived-subjects" type="button" role="tab" 
                                    aria-controls="archived-subjects" aria-selected="false">
                                <i class="fas fa-archive me-2"></i>Archive
                            </button>
                        </li>
                    </ul>

                    <!-- Mobile Tab Navigation -->
                    <div class="d-md-none mb-4">
                        <div class="row g-2">
                            <div class="col-6">
                                <button class="btn btn-primary w-100" id="mobile-active-subjects-tab" 
                                        data-bs-toggle="tab" data-bs-target="#active-subjects" type="button">
                                    <i class="fas fa-book d-block mb-1"></i>
                                    <small>Active Subjects</small>
                                </button>
                            </div>
                            <div class="col-6">
                                <button class="btn btn-outline-primary w-100" id="mobile-archived-subjects-tab" 
                                        data-bs-toggle="tab" data-bs-target="#archived-subjects" type="button">
                                    <i class="fas fa-archive d-block mb-1"></i>
                                    <small>Archive</small>
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <div class="tab-content" id="subjectsTabContent">
                        <div class="tab-pane fade show active" id="active-subjects" role="tabpanel" 
                             aria-labelledby="active-subjects-tab">
                            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('subjects-list');

$__html = app('livewire')->mount($__name, $__params, 'lw-4008298351-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                        </div>
                        <div class="tab-pane fade" id="archived-subjects" role="tabpanel" 
                             aria-labelledby="archived-subjects-tab">
                            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('deleted-subjects-list');

$__html = app('livewire')->mount($__name, $__params, 'lw-4008298351-1', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const mobileActiveBtn = document.getElementById('mobile-active-subjects-tab');
    const mobileArchivedBtn = document.getElementById('mobile-archived-subjects-tab');
    const desktopActiveTab = document.getElementById('active-subjects-tab');
    const desktopArchivedTab = document.getElementById('archived-subjects-tab');
    
    // Handle mobile tab clicks
    mobileActiveBtn.addEventListener('click', function() {
        // Trigger desktop tab
        const tab = new bootstrap.Tab(desktopActiveTab);
        tab.show();
        // Update mobile button states
        mobileActiveBtn.className = 'btn btn-primary w-100';
        mobileArchivedBtn.className = 'btn btn-outline-primary w-100';
    });
    
    mobileArchivedBtn.addEventListener('click', function() {
        // Trigger desktop tab
        const tab = new bootstrap.Tab(desktopArchivedTab);
        tab.show();
        // Update mobile button states
        mobileArchivedBtn.className = 'btn btn-primary w-100';
        mobileActiveBtn.className = 'btn btn-outline-primary w-100';
    });
    
    // Sync mobile buttons when desktop tabs change
    desktopActiveTab.addEventListener('shown.bs.tab', function() {
        mobileActiveBtn.className = 'btn btn-primary w-100';
        mobileArchivedBtn.className = 'btn btn-outline-primary w-100';
    });
    
    desktopArchivedTab.addEventListener('shown.bs.tab', function() {
        mobileArchivedBtn.className = 'btn btn-primary w-100';
        mobileActiveBtn.className = 'btn btn-outline-primary w-100';
    });
});
</script>

<!-- Create Subject Modal -->
<div class="modal fade" id="createSubjectModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-primary">
                <h5 class="modal-title text-white">Add New Subject</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('create-subject-form');

$__html = app('livewire')->mount($__name, $__params, 'lw-4008298351-2', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.school-portal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\edu-p\resources\views/subjects/index.blade.php ENDPATH**/ ?>