<div>
    <style>
        .results-table {
            font-size: 0.875rem;
        }
        
        .results-table .form-control {
            min-width: 60px;
            width: 70px;
            text-align: center;
        }
        
        .student-name-cell {
            min-width: 120px;
            word-wrap: break-word;
            position: sticky;
            left: 0;
            background-color: #f8f9fa;
            z-index: 10;
        }
        
        .results-table tbody .student-name-cell {
            background-color: white;
            z-index: 5;
        }
        
        @media (max-width: 768px) {
            .results-table {
                font-size: 0.75rem;
            }
            
            .results-table .form-control {
                min-width: 45px;
                width: 50px;
                padding: 0.25rem 0.125rem;
                font-size: 0.75rem;
            }
            
            .student-name-cell {
                min-width: 80px;
                font-size: 0.7rem;
            }
            
            .results-table tbody .student-name-cell {
                box-shadow: 2px 0 5px rgba(0,0,0,0.1);
            }
            
            .results-table th {
                padding: 0.25rem 0.125rem;
                font-size: 0.7rem;
            }
            
            .results-table td {
                padding: 0.25rem 0.125rem;
            }
        }
    </style>
    <!--[if BLOCK]><![endif]--><?php if(!$canUploadResults): ?>
        <div class="alert alert-warning mb-4">
            <i class="fas fa-exclamation-triangle me-2"></i>
            <?php echo e($uploadDisabledMessage); ?>

        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!--[if BLOCK]><![endif]--><?php if($excludedStudentsCount > 0): ?>
        <div class="alert alert-info mb-4">
            <i class="fas fa-info-circle me-2"></i>
            <?php echo e($excludedStudentsCount); ?> student<?php echo e($excludedStudentsCount > 1 ? 's' : ''); ?> excluded because their
            results have already been approved.
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <form wire:submit.prevent="saveResults" <?php echo e(!$canUploadResults ? 'style=pointer-events:none;opacity:0.6;' : ''); ?>>
        <div class="row mb-4">
            <div class="col-md-6 col-lg-3">
                <label for="selectedClass" class="form-label">Select Class</label>
                <select wire:model.live="selectedClass" class="form-select" id="selectedClass">
                    <option value="">Choose a class...</option>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($class->id); ?>"><?php echo e($class->display_name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </select>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedClass'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="col-md-6 col-lg-3">
                <label for="selectedBatch" class="form-label">Select Batch</label>
                <select wire:model.live="selectedBatch" class="form-select"
                        id="selectedBatch" <?php echo e(!$selectedClass ? 'disabled' : ''); ?>>
                    <option value="">Choose a batch...</option>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($batch->id); ?>"><?php echo e($batch->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </select>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedBatch'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="col-md-6 col-lg-3">
                <label for="selectedSession" class="form-label">Select Session</label>
                <select wire:model.live="selectedSession" class="form-select" id="selectedSession">
                    <option value="">Choose a session...</option>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($session->id); ?>"><?php echo e($session->name); ?> (<?php echo e($session->start_year); ?>

                            /<?php echo e($session->end_year); ?>)
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </select>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedSession'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="col-md-6 col-lg-3">
                <label class="form-label">&nbsp;</label>
                <!--[if BLOCK]><![endif]--><?php if($selectedClass && $selectedBatch && $selectedSession): ?>
                    <button type="button"
                            wire:click="loadResults"
                            class="btn btn-primary w-100"
                            wire:loading.attr="disabled"
                            wire:target="loadResults">
                        <span wire:loading.remove wire:target="loadResults">
                            <i class="fas fa-sync me-2"></i>Load
                        </span>
                        <span wire:loading wire:target="loadResults">
                            <i class="fas fa-spinner fa-spin me-2"></i>Loading...
                        </span>
                    </button>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>

        <!--[if BLOCK]><![endif]--><?php if(!empty($students) && !empty($subjects)): ?>
            <div class="mb-3">
                <h5>Class: <?php echo e($classes->find($selectedClass)->display_name ?? 'N/A'); ?> -
                    Batch: <?php echo e($batches->find($selectedBatch)->name ?? 'N/A'); ?></h5>
            </div>
            <div class="table-responsive">
                <table class="table table-bordered table-sm results-table">
                    <thead class="table-light">
                    <tr>
                        <th rowspan="2" class="student-name-cell">
                            Student
                        </th>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <th colspan="4" class="text-center"><?php echo e($subject->display_name); ?></th>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </tr>
                    <tr>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <th class="text-center">CA</th>
                            <th class="text-center" style="width: 40px;">Abs</th>
                            <th class="text-center">Exam</th>
                            <th class="text-center" style="width: 40px;">Abs</th>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </tr>
                    </thead>
                    <tbody>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="student-name-cell">
                                <strong><?php echo e($loop->iteration); ?>. <?php echo e($student->name); ?></strong>
                            </td>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td>
                                    <input type="number"
                                           wire:model.defer="results.<?php echo e($student->id); ?>.<?php echo e($subject->id); ?>.ca_score"
                                           class="form-control form-control-sm result-input"
                                           data-student="<?php echo e($student->id); ?>"
                                           data-subject="<?php echo e($subject->id); ?>"
                                           data-field="ca_score"
                                           min="0"
                                           max="<?php echo e($sessions->find($selectedSession)->ca_max_score ?? 100); ?>"
                                           step="1"
                                           placeholder="CA"
                                           tabindex="<?php echo e(($loop->parent->iteration - 1) * count($subjects) * 2 + ($loop->iteration - 1) * 2 + 1); ?>"
                                        <?php echo e(($results[$student->id][$subject->id]['ca_absent'] ?? false) ? 'disabled' : ''); ?>>
                                </td>
                                <td class="text-center" style="width: 40px;">
                                    <input type="checkbox"
                                           wire:model.defer="results.<?php echo e($student->id); ?>.<?php echo e($subject->id); ?>.ca_absent"
                                           class="form-check-input absent-checkbox"
                                           data-student="<?php echo e($student->id); ?>"
                                           data-subject="<?php echo e($subject->id); ?>"
                                           data-field="ca_absent"
                                           data-target="ca_score"
                                           tabindex="-1">
                                </td>
                                <td>
                                    <input type="number"
                                           wire:model.defer="results.<?php echo e($student->id); ?>.<?php echo e($subject->id); ?>.exam_score"
                                           class="form-control form-control-sm result-input"
                                           data-student="<?php echo e($student->id); ?>"
                                           data-subject="<?php echo e($subject->id); ?>"
                                           data-field="exam_score"
                                           min="0"
                                           max="<?php echo e($sessions->find($selectedSession)->exam_max_score ?? 100); ?>"
                                           step="1"
                                           placeholder="Exam"
                                           tabindex="<?php echo e(($loop->parent->iteration - 1) * count($subjects) * 2 + ($loop->iteration - 1) * 2 + 2); ?>"
                                        <?php echo e(($results[$student->id][$subject->id]['exam_absent'] ?? false) ? 'disabled' : ''); ?>>
                                </td>
                                <td class="text-center" style="width: 40px;">
                                    <input type="checkbox"
                                           wire:model.defer="results.<?php echo e($student->id); ?>.<?php echo e($subject->id); ?>.exam_absent"
                                           class="form-check-input absent-checkbox"
                                           data-student="<?php echo e($student->id); ?>"
                                           data-subject="<?php echo e($subject->id); ?>"
                                           data-field="exam_absent"
                                           data-target="exam_score"
                                           tabindex="-1">
                                </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </tbody>
                </table>
            </div>

            <div class="d-flex justify-content-end mt-3">
                <button type="submit" class="btn btn-success btn-lg">
                    <i class="fas fa-save me-2"></i>Save All Results
                </button>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </form>
</div>

<script>
    let updateCounter = 0;
    let pendingUpdates = new Set();

    document.addEventListener('input', function (e) {
        if (e.target.type === 'number' && e.target.hasAttribute('max')) {
            const max = parseInt(e.target.getAttribute('max'));
            const value = parseInt(e.target.value);
            if (value > max) {
                e.target.setCustomValidity(`Value must not exceed ${max}`);
                e.target.reportValidity();
            } else {
                e.target.setCustomValidity('');
            }
        }
        
        // Track result input changes
        if (e.target.classList.contains('result-input')) {
            const studentId = e.target.dataset.student;
            const subjectId = e.target.dataset.subject;
            const key = `${studentId}_${subjectId}`;
            
            if (!pendingUpdates.has(key)) {
                pendingUpdates.add(key);
                updateCounter++;
                
                if (updateCounter >= 10) {
                    saveUpdates();
                }
            }
        }
    });
    
    document.addEventListener('change', function (e) {
        // Handle absent checkbox changes
        if (e.target.classList.contains('absent-checkbox')) {
            const studentId = e.target.dataset.student;
            const subjectId = e.target.dataset.subject;
            const targetField = e.target.dataset.target;
            
            // Disable/enable corresponding input
            const targetInput = document.querySelector(
                `input[data-student="${studentId}"][data-subject="${subjectId}"][data-field="${targetField}"]`
            );
            
            if (targetInput) {
                if (e.target.checked) {
                    targetInput.value = 0;
                    targetInput.disabled = true;
                } else {
                    targetInput.disabled = false;
                }
            }
            
            const key = `${studentId}_${subjectId}`;
            if (!pendingUpdates.has(key)) {
                pendingUpdates.add(key);
                updateCounter++;
                
                if (updateCounter >= 10) {
                    saveUpdates();
                }
            }
        }
    });
    
    function saveUpdates() {
        if (updateCounter > 0) {
            window.Livewire.find('<?php echo e($_instance->getId()); ?>').call('processPendingUpdates');
            updateCounter = 0;
            pendingUpdates.clear();
        }
    }
    
    // Save any remaining updates before form submission
    document.addEventListener('livewire:init', () => {
        Livewire.hook('commit', ({ component, commit, respond, succeed, fail }) => {
            if (component.name === 'results.by-class-form') {
                saveUpdates();
            }
        });
    });
</script>
<?php /**PATH C:\wamp64\www\edu-p\resources\views/livewire/results/by-class-form.blade.php ENDPATH**/ ?>