<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Required meta tags-->
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Rosa Mystica Portal">
    <meta name="author" content="Rosa Mystica">
    <link rel="icon" href="<?php echo e(asset('images/rosa-mys-logo.png')); ?>" type="image/x-icon">

    <title><?php echo $__env->yieldContent('title', 'Dashboard'); ?> - <?php echo e(config('app.name')); ?></title>

    <!-- Bootstrap CSS-->
    <link href="<?php echo e(asset('vendor/bootstrap-5.3.7.min.css')); ?>" rel="stylesheet" media="all">
    <link href="<?php echo e(asset('vendor/fontawesome-6.7.2/css/all.min.css')); ?>" rel="stylesheet" media="all">

    <!-- Main CSS-->
    <link href="<?php echo e(asset('css/school-portal.css')); ?>" rel="stylesheet" media="all">

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body class="dashboard-body">

<?php if (isset($component)) { $__componentOriginalfd1f218809a441e923395fcbf03e4272 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfd1f218809a441e923395fcbf03e4272 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.header','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfd1f218809a441e923395fcbf03e4272)): ?>
<?php $attributes = $__attributesOriginalfd1f218809a441e923395fcbf03e4272; ?>
<?php unset($__attributesOriginalfd1f218809a441e923395fcbf03e4272); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfd1f218809a441e923395fcbf03e4272)): ?>
<?php $component = $__componentOriginalfd1f218809a441e923395fcbf03e4272; ?>
<?php unset($__componentOriginalfd1f218809a441e923395fcbf03e4272); ?>
<?php endif; ?>
<?php if(auth()->user()->isStudent()): ?>
    <?php if (isset($component)) { $__componentOriginal6fbe3402d2badf7cc8fd23b41008e41a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6fbe3402d2badf7cc8fd23b41008e41a = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.student-sidebar','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('student-sidebar'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6fbe3402d2badf7cc8fd23b41008e41a)): ?>
<?php $attributes = $__attributesOriginal6fbe3402d2badf7cc8fd23b41008e41a; ?>
<?php unset($__attributesOriginal6fbe3402d2badf7cc8fd23b41008e41a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6fbe3402d2badf7cc8fd23b41008e41a)): ?>
<?php $component = $__componentOriginal6fbe3402d2badf7cc8fd23b41008e41a; ?>
<?php unset($__componentOriginal6fbe3402d2badf7cc8fd23b41008e41a); ?>
<?php endif; ?>
<?php else: ?>
    <?php if (isset($component)) { $__componentOriginal2880b66d47486b4bfeaf519598a469d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal2880b66d47486b4bfeaf519598a469d6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.sidebar','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('sidebar'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal2880b66d47486b4bfeaf519598a469d6)): ?>
<?php $attributes = $__attributesOriginal2880b66d47486b4bfeaf519598a469d6; ?>
<?php unset($__attributesOriginal2880b66d47486b4bfeaf519598a469d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal2880b66d47486b4bfeaf519598a469d6)): ?>
<?php $component = $__componentOriginal2880b66d47486b4bfeaf519598a469d6; ?>
<?php unset($__componentOriginal2880b66d47486b4bfeaf519598a469d6); ?>
<?php endif; ?>
<?php endif; ?>

<!-- Sidebar Toggle Arrow -->
<button class="sidebar-toggle-arrow" id="sidebarToggle">
    <i class="fas fa-chevron-right"></i>
    <span class="sidebar-text">sidebar</span>
</button>

<div class="page-wrapper">
    <div class="page-content">
        <?php echo $__env->yieldContent('content'); ?>
    </div>
</div>
<?php if (isset($component)) { $__componentOriginal99051027c5120c83a2f9a5ae7c4c3cfa = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal99051027c5120c83a2f9a5ae7c4c3cfa = $attributes; } ?>
<?php $component = App\View\Components\Footer::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('footer'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Footer::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal99051027c5120c83a2f9a5ae7c4c3cfa)): ?>
<?php $attributes = $__attributesOriginal99051027c5120c83a2f9a5ae7c4c3cfa; ?>
<?php unset($__attributesOriginal99051027c5120c83a2f9a5ae7c4c3cfa); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal99051027c5120c83a2f9a5ae7c4c3cfa)): ?>
<?php $component = $__componentOriginal99051027c5120c83a2f9a5ae7c4c3cfa; ?>
<?php unset($__componentOriginal99051027c5120c83a2f9a5ae7c4c3cfa); ?>
<?php endif; ?>

<?php echo $__env->yieldContent('modals'); ?>

<!-- Livewire Loading Animation -->
<div id="livewire-loader" class="livewire-loader" style="display: none;">
    <div class="loader-dots">
        <div class="dot"></div>
        <div class="dot"></div>
        <div class="dot"></div>
    </div>
</div>

<!-- JS-->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="<?php echo e(asset('vendor/bootstrap-5.3.7.bundle.min.js')); ?>"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="<?php echo e(asset('js/school-portal.js')); ?>"></script>
<script>
    let gradeChart = null;
    let classGradeChart = null;

    window.initGradeChart = function (canvasId, labels, data, title) {
        const ctx = document.getElementById(canvasId);
        if (!ctx) {
            console.log('Canvas not found: ' + canvasId);
            return;
        }

        // Force destroy any existing chart
        const existingChart = Chart.getChart(ctx);
        if (existingChart) {
            existingChart.destroy();
        }

        // Clear canvas
        ctx.getContext('2d').clearRect(0, 0, ctx.width, ctx.height);

        // Determine chart type based on canvas ID
        const chartType = canvasId === 'classGradeChart' ? 'bar' : 'line';

        const chart = new Chart(ctx, {
            type: chartType,
            data: {
                labels: labels,
                datasets: [{
                    label: title || 'Performance',
                    data: data,
                    borderColor: '#007bff',
                    backgroundColor: chartType === 'bar' ? 'rgba(0, 123, 255, 0.8)' : 'rgba(0, 123, 255, 0.1)',
                    borderWidth: chartType === 'bar' ? 1 : 3,
                    fill: chartType === 'line',
                    tension: chartType === 'line' ? 0.4 : undefined,
                    pointBackgroundColor: chartType === 'line' ? '#007bff' : undefined,
                    pointBorderColor: chartType === 'line' ? '#007bff' : undefined,
                    pointRadius: chartType === 'line' ? 4 : undefined,
                    pointHoverRadius: chartType === 'line' ? 6 : undefined
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        max: chartType === 'line' ? 10 : 100,
                        ticks: {
                            stepSize: chartType === 'line' ? 1 : 10
                        }
                    }
                }
            }
        });
    }
</script>

<?php if(session('toast')): ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const toastData = <?php echo json_encode(session('toast'), 15, 512) ?>;
            showToast(toastData.type, toastData.message, toastData.title, toastData.icon);
        });
    </script>
<?php endif; ?>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const loader = document.getElementById('livewire-loader');
        let activeRequests = 0;
        let safetyTimeout;

        function showLoader() {
            activeRequests++;
            loader.style.display = 'flex';

            // Safety timeout - hide after 10 seconds max
            clearTimeout(safetyTimeout);
            safetyTimeout = setTimeout(() => {
                activeRequests = 0;
                loader.style.display = 'none';
            }, 10000);
        }

        function hideLoader() {
            activeRequests--;
            if (activeRequests <= 0) {
                activeRequests = 0;
                clearTimeout(safetyTimeout);
                loader.style.display = 'none';
            }
        }

        document.addEventListener('livewire:init', () => {
            Livewire.hook('request', showLoader);
            Livewire.hook('response', hideLoader);
            Livewire.hook('commit', hideLoader);
            Livewire.hook('morph.updated', hideLoader);
        });
    });
</script>


<?php echo $__env->yieldPushContent('scripts'); ?>

</body>

</html>
<?php /**PATH C:\wamp64\www\edu-p\resources\views/layouts/school-portal.blade.php ENDPATH**/ ?>