<div class="sidebar" id="sidebar">
    <div class="sidebar-header">
        <img src="<?php echo e(asset('images/rosa-mys-logo.png')); ?>" alt="Logo" class="sidebar-logo me-3">
        <h5 style="color: var(--bs-primary);">
            <?php if(auth()->user()->isAdmin()): ?>
                Administrator
            <?php elseif(auth()->user()->isHeadTeacher()): ?>
                Head Teacher
            <?php elseif(auth()->user()->isBursar()): ?>
                Bursar
            <?php elseif(auth()->user()->isTeacher()): ?>
                Teacher
            <?php elseif(auth()->user()->hasRole('driver')): ?>
                Driver
            <?php elseif(auth()->user()->hasRole('security')): ?>
                Security
            <?php elseif(auth()->user()->hasRole('cleaner')): ?>
                Cleaner
            <?php else: ?>
                Student
            <?php endif; ?>
        </h5>
    </div>

    <nav class="sidebar-nav">
        <a href="<?php echo e(route('dashboard')); ?>" class="nav-item <?php echo e(request()->routeIs('dashboard') ? 'active' : ''); ?>">
            <i class="fas fa-tachometer-alt"></i>
            <span>Dashboard</span>
        </a>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-students')): ?>
            <div class="nav-item dropdown-sidebar">
                <a href="#" class="nav-link-sidebar" data-bs-toggle="collapse" data-bs-target="#studentsDropdown"
                    <?php echo e(request()->routeIs('students.*') ? 'aria-expanded=true' : ''); ?>>
                    <i class="fas fa-user-graduate"></i>
                    <span>Students</span>
                    <i class="fas fa-chevron-down ms-2 dropdown-arrow"></i>
                </a>
                <div class="collapse <?php echo e(request()->routeIs('students.*') ? 'show' : ''); ?>" id="studentsDropdown">
                    <a href="<?php echo e(route('students.index')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('students.index') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-list"></i>
                        <span>All Students</span>
                    </a>
                    <a href="<?php echo e(route('students.create')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('students.create')|| request()->routeIs('students.edit') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-plus"></i>
                        <span>Add Student</span>
                    </a>
                </div>
            </div>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('head-teacher')): ?>
            <div class="nav-item dropdown-sidebar">
                <a href="#" class="nav-link-sidebar" data-bs-toggle="collapse" data-bs-target="#staffDropdown"
                    <?php echo e(request()->routeIs('staff.*') ? 'aria-expanded=true' : ''); ?>>
                    <i class="fas fa-chalkboard-teacher"></i>
                    <span>Staff</span>
                    <i class="fas fa-chevron-down ms-2 dropdown-arrow"></i>
                </a>
                <div class="collapse <?php echo e(request()->routeIs('staff.*') ? 'show' : ''); ?>" id="staffDropdown">
                    <a href="<?php echo e(route('staff.index')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('staff.index') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-list"></i>
                        <span>All Staff</span>
                    </a>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin')): ?>
                        <a href="<?php echo e(route('staff.create')); ?>"
                           class="nav-sub-item <?php echo e(request()->routeIs('staff.create') || request()->routeIs('staff.edit') ? 'active' : ''); ?>"
                           style="padding-left: 50px;">
                            <i class="fas fa-plus"></i>
                            <span>Add Staff</span>
                        </a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('staff.assign-classes')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('staff.assign-classes') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-chalkboard"></i>
                        <span>Assign Classes</span>
                    </a>
                </div>
            </div>
        <?php endif; ?>


        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin')): ?>
            <div class="nav-item dropdown-sidebar">
                <a href="#" class="nav-link-sidebar" data-bs-toggle="collapse" data-bs-target="#subjectsDropdown"
                    <?php echo e(request()->routeIs('subjects.*') ? 'aria-expanded=true' : ''); ?>>
                    <i class="fas fa-book"></i>
                    <span>Subjects</span>
                    <i class="fas fa-chevron-down ms-2 dropdown-arrow"></i>
                </a>
                <div class="collapse <?php echo e(request()->routeIs('subjects.*') ? 'show' : ''); ?>" id="subjectsDropdown">
                    <a href="<?php echo e(route('subjects.index')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('subjects.index') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-list"></i>
                        <span>All Subjects</span>
                    </a>

                    <a href="<?php echo e(route('subjects.assign-classes')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('subjects.assign-classes') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-link"></i>
                        <span>Assign to Classes</span>
                    </a>
                </div>
            </div>
        <?php endif; ?>
        

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-results')): ?>
            <div class="nav-item dropdown-sidebar">
                <a href="#" class="nav-link-sidebar" data-bs-toggle="collapse" data-bs-target="#termlyResultsDropdown"
                    <?php echo e(request()->routeIs('results.by-*', 'results.offline-upload', 'results.approval', 'results.master-list', 'results.view-results') ? 'aria-expanded=true' : ''); ?>>
                    <i class="fas fa-chart-line"></i>
                    <span>Termly Results</span>
                    <i class="fas fa-chevron-down ms-2 dropdown-arrow"></i>
                </a>
                <div
                    class="collapse <?php echo e(request()->routeIs('results.by-*', 'results.offline-upload', 'results.approval', 'results.master-list', 'results.view-results') ? 'show' : ''); ?>"
                    id="termlyResultsDropdown">
                    <a href="<?php echo e(route('results.by-student')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('results.by-student') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-user"></i>
                        <span>By Student</span>
                    </a>
                    <a href="<?php echo e(route('results.by-class')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('results.by-class') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-users"></i>
                        <span>By Class</span>
                    </a>
                    <a href="<?php echo e(route('results.by-subject')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('results.by-subject') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-book"></i>
                        <span>By Subject</span>
                    </a>
                    <a href="<?php echo e(route('results.offline-upload')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('results.offline-upload') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-file-excel me-2"></i>
                        <span>Offline Upload</span>
                    </a>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('approve-results')): ?>
                        <a href="<?php echo e(route('results.approval')); ?>"
                           class="nav-sub-item <?php echo e(request()->routeIs('results.approval') ? 'active' : ''); ?>"
                           style="padding-left: 50px;">
                            <i class="fas fa-check-circle"></i>
                            <span>Approve Results</span>
                        </a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('results.master-list')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('results.master-list') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-list-alt"></i>
                        <span>Master List</span>
                    </a>
                    <a href="<?php echo e(route('results.view-results')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('results.view-results') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-eye"></i>
                        <span>View Approved Results</span>
                    </a>
                </div>
            </div>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-results')): ?>
            <div class="nav-item dropdown-sidebar">
                <a href="#" class="nav-link-sidebar" data-bs-toggle="collapse" data-bs-target="#annualResultsDropdown"
                    <?php echo e(request()->routeIs('results.annual-*', 'results.student-annual-*', 'results.view-annual-results') ? 'aria-expanded=true' : ''); ?>>
                    <i class="fas fa-calendar-alt"></i>
                    <span>Annual Results</span>
                    <i class="fas fa-chevron-down ms-2 dropdown-arrow"></i>
                </a>
                <div
                    class="collapse <?php echo e(request()->routeIs('results.annual-*', 'results.student-annual-*', 'results.view-annual-results') ? 'show' : ''); ?>"
                    id="annualResultsDropdown">
                    <a href="<?php echo e(route('results.annual-results')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('results.annual-results') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-chart-line"></i>
                        <span>Class Annual Results</span>
                    </a>
                    <a href="<?php echo e(route('results.annual-master-list')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('results.annual-master-list') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-list-alt"></i>
                        <span>Annual Master List</span>
                    </a>
                    <a href="<?php echo e(route('results.student-annual-result')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('results.student-annual-result') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-user-clock"></i>
                        <span>Student Annual Result</span>
                    </a>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('approve-results')): ?>
                        <a href="<?php echo e(route('results.annual-approval')); ?>"
                           class="nav-sub-item <?php echo e(request()->routeIs('results.annual-approval') ? 'active' : ''); ?>"
                           style="padding-left: 50px;">
                            <i class="fas fa-check-circle me-2"></i>
                            <span>Approve Annual Results</span>
                        </a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('results.view-annual-results')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('results.view-annual-results') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-eye me-2"></i>
                        <span>View Approved Annual Results</span>
                    </a>
                </div>
            </div>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('head-teacher')): ?>
            <div class="nav-item dropdown-sidebar">
                <a href="#" class="nav-link-sidebar" data-bs-toggle="collapse" data-bs-target="#promotionDropdown"
                    <?php echo e(request()->routeIs('promotion.*') ? 'aria-expanded=true' : ''); ?>>
                    <i class="fas fa-level-up-alt"></i>
                    <span>Promotion</span>
                    <i class="fas fa-chevron-down ms-2 dropdown-arrow"></i>
                </a>
                <div class="collapse <?php echo e(request()->routeIs('promotion.*') ? 'show' : ''); ?>" id="promotionDropdown">
                    <a href="<?php echo e(route('promotion.by-class')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('promotion.by-class') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-users"></i>
                        <span>By Class</span>
                    </a>
                    <a href="<?php echo e(route('promotion.by-batch')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('promotion.by-batch') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-layer-group"></i>
                        <span>By Batch</span>
                    </a>
                    <a href="<?php echo e(route('promotion.individual')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('promotion.individual') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-user"></i>
                        <span>Individual</span>
                    </a>
                </div>
            </div>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('head-teacher')): ?>
            <div class="nav-item dropdown-sidebar">
                <a href="#" class="nav-link-sidebar" data-bs-toggle="collapse" data-bs-target="#announcementsDropdown"
                    <?php echo e(request()->routeIs('announcements.*') ? 'aria-expanded=true' : ''); ?>>
                    <i class="fas fa-bullhorn"></i>
                    <span>Announcements</span>
                    <i class="fas fa-chevron-down ms-2 dropdown-arrow"></i>
                </a>
                <div class="collapse <?php echo e(request()->routeIs('announcements.*') ? 'show' : ''); ?>"
                     id="announcementsDropdown">
                    <a href="<?php echo e(route('announcements.index')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('announcements.index') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-list"></i>
                        <span>All Announcements</span>
                    </a>
                    <a href="<?php echo e(route('announcements.create')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('announcements.create') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-plus"></i>
                        <span>Create Announcement</span>
                    </a>
                </div>
            </div>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-payments')): ?>
            <div class="nav-item dropdown-sidebar">
                <a href="#" class="nav-link-sidebar" data-bs-toggle="collapse" data-bs-target="#paymentRequestsDropdown"
                    <?php echo e(request()->routeIs('payment-requests.*', 'payments.*') ? 'aria-expanded=true' : ''); ?>>
                    <i class="fas fa-money-bill-wave"></i>
                    <span>Payments</span>
                    <i class="fas fa-chevron-down ms-2 dropdown-arrow"></i>
                </a>
                <div class="collapse <?php echo e(request()->routeIs('payment-requests.*', 'payments.*') ? 'show' : ''); ?>"
                     id="paymentRequestsDropdown">
                    <a href="<?php echo e(route('payment-requests.index')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('payment-requests.index') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-list"></i>
                        <span>Payment Requests</span>
                    </a>
                    <a href="<?php echo e(route('payment-requests.create')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('payment-requests.create') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-plus"></i>
                        <span>Create Payment Request</span>
                    </a>
                    <a href="<?php echo e(route('payment-requests.view-by-target')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('payment-requests.view-by-target') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-search"></i>
                        <span>View Requests by Target</span>
                    </a>
                    <a href="<?php echo e(route('payments.history')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('payments.history', 'payments.view') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-history"></i>
                        <span>Payment Records</span>
                    </a>
                </div>
            </div>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-payments')): ?>
            <div class="nav-item dropdown-sidebar">
                <a href="#" class="nav-link-sidebar" data-bs-toggle="collapse" data-bs-target="#payrollDropdown"
                    <?php echo e(request()->routeIs('payroll.*') ? 'aria-expanded=true' : ''); ?>>
                    <i class="fas fa-wallet"></i>
                    <span>Payroll System</span>
                    <i class="fas fa-chevron-down ms-2 dropdown-arrow"></i>
                </a>
                <div class="collapse <?php echo e(request()->routeIs('payroll.*') ? 'show' : ''); ?>" id="payrollDropdown">
                    <a href="<?php echo e(route('payroll.index')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('payroll.index') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-tachometer-alt"></i>
                        <span>Salaries Dashboard</span>
                    </a>
                    <a href="<?php echo e(route('payroll.staff-salaries')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('payroll.staff-salaries') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-users me-2"></i>
                        <span>Salary Settings</span>
                    </a>
                    <a href="<?php echo e(route('payroll.salary-history')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('payroll.salary-history') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-history me-2"></i>
                        <span>Monthly Salaries</span>
                    </a>
                </div>
            </div>
        <?php endif; ?>

        <?php if(auth()->user()->isStaff()): ?>
            <?php
                $salaryViewSetting = \App\Models\Setting::where('key', 'allow_staff_salary_view')->first();
                $allowView = $salaryViewSetting ? (bool) $salaryViewSetting->value : true;
            ?>
            <?php if($allowView || auth()->user()->can('manage-payments')): ?>
                <a href="<?php echo e(route('staff.salary-history')); ?>"
                   class="nav-item <?php echo e(request()->routeIs('staff.salary-history') ? 'active' : ''); ?>">
                    <i class="fas fa-money-check-alt me-2"></i>
                    <span>My Salary History</span>
                </a>
            <?php endif; ?>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('head-teacher')): ?>
            <div class="nav-item dropdown-sidebar">
                <a href="#" class="nav-link-sidebar" data-bs-toggle="collapse" data-bs-target="#batchesDropdown"
                    <?php echo e(request()->routeIs('batches.*') ? 'aria-expanded=true' : ''); ?>>
                    <i class="fas fa-layer-group"></i>
                    <span> Batches</span>
                    <i class="fas fa-chevron-down ms-2 dropdown-arrow"></i>
                </a>
                <div class="collapse <?php echo e(request()->routeIs('batches.*') ? 'show' : ''); ?>" id="batchesDropdown">
                    <a href="<?php echo e(route('batches.index')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('batches.index') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-list"></i>
                        <span>All Batches</span>
                    </a>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin')): ?>
                        <a href="<?php echo e(route('batches.create')); ?>"
                           class="nav-sub-item <?php echo e(request()->routeIs('batches.create') ? 'active' : ''); ?>"
                           style="padding-left: 50px;">
                            <i class="fas fa-plus"></i>
                            <span>Create Batch</span>
                        </a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('batches.assign-students')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('batches.assign-students') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-user-plus"></i>
                        <span>Assign Students</span>
                    </a>
                </div>
            </div>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin')): ?>
            <div class="nav-item dropdown-sidebar">
                <a href="#" class="nav-link-sidebar" data-bs-toggle="collapse" data-bs-target="#settingsDropdown"
                    <?php echo e(request()->routeIs('school-sessions.*', 'school-classes.*', 'settings.*') ? 'aria-expanded=true' : ''); ?>>
                    <i class="fas fa-cog"></i>
                    <span>Settings</span>
                    <i class="fas fa-chevron-down ms-2 dropdown-arrow"></i>
                </a>
                <div
                    class="collapse <?php echo e(request()->routeIs('school-sessions.*', 'school-classes.*', 'settings.*') ? 'show' : ''); ?>"
                    id="settingsDropdown">
                    <a href="#" class="nav-sub-item" data-bs-toggle="collapse" data-bs-target="#sessionsDropdown"
                        <?php echo e(request()->routeIs('school-sessions.*') ? 'aria-expanded=true' : ''); ?>>
                        <i class="fas fa-calendar-alt"></i>
                        <span>Sessions</span>
                        <i class="fas fa-chevron-down ms-auto dropdown-arrow"></i>
                    </a>
                    <div class="collapse <?php echo e(request()->routeIs('school-sessions.*') ? 'show' : ''); ?>"
                         id="sessionsDropdown">
                        <a href="<?php echo e(route('school-sessions.index')); ?>"
                           class="nav-sub-item <?php echo e(request()->routeIs('school-sessions.index') ? 'active' : ''); ?>"
                           style="padding-left: 75px;">
                            <i class="fas fa-list"></i>
                            <span>All Sessions</span>
                        </a>
                        <a href="<?php echo e(route('school-sessions.create')); ?>"
                           class="nav-sub-item <?php echo e(request()->routeIs('school-sessions.create') ? 'active' : ''); ?>"
                           style="padding-left: 75px;">
                            <i class="fas fa-plus"></i>
                            <span>Create Session</span>
                        </a>
                    </div>
                    <a href="#" class="nav-sub-item" data-bs-toggle="collapse" data-bs-target="#classesDropdown"
                        <?php echo e(request()->routeIs('school-classes.*') ? 'aria-expanded=true' : ''); ?>>
                        <i class="fas fa-school"></i>
                        <span>Classes</span>
                        <i class="fas fa-chevron-down ms-auto dropdown-arrow"></i>
                    </a>
                    <div class="collapse <?php echo e(request()->routeIs('school-classes.*') ? 'show' : ''); ?>"
                         id="classesDropdown">
                        <a href="<?php echo e(route('school-classes.index')); ?>"
                           class="nav-sub-item <?php echo e(request()->routeIs('school-classes.index') ? 'active' : ''); ?>"
                           style="padding-left: 75px;">
                            <i class="fas fa-list"></i>
                            <span>All Classes</span>
                        </a>
                        <a href="<?php echo e(route('school-classes.create')); ?>"
                           class="nav-sub-item <?php echo e(request()->routeIs('school-classes.create') ? 'active' : ''); ?>"
                           style="padding-left: 75px;">
                            <i class="fas fa-plus"></i>
                            <span>Create Class</span>
                        </a>
                        <a href="<?php echo e(route('school-classes.reorder')); ?>"
                           class="nav-sub-item <?php echo e(request()->routeIs('school-classes.reorder') ? 'active' : ''); ?>"
                           style="padding-left: 75px;">
                            <i class="fas fa-sort"></i>
                            <span>Reorder Classes</span>
                        </a>
                    </div>

                    <a href="<?php echo e(route('settings.annual-pass-percentage')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('settings.annual-pass-percentage') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-percentage"></i>
                        <span>Annual Pass Percentage</span>
                    </a>
                    <a href="<?php echo e(route('settings.result-settings')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('settings.result-settings') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-cogs"></i>
                        <span>Result Settings</span>
                    </a>
                    <a href="<?php echo e(route('settings.school-officials')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('settings.school-officials') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-user-tie"></i>
                        <span>School Officials</span>
                    </a>
                    <a href="<?php echo e(route('settings.school-info')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('settings.school-info') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-school"></i>
                        <span>School Information</span>
                    </a>
                    <a href="<?php echo e(route('settings.finance')); ?>"
                       class="nav-sub-item <?php echo e(request()->routeIs('settings.finance') ? 'active' : ''); ?>"
                       style="padding-left: 50px;">
                        <i class="fas fa-university"></i>
                        <span>Finance</span>
                    </a>
                </div>
            </div>
        <?php endif; ?>

        <?php if(!auth()->user()->isStudent()): ?>
            <a href="<?php echo e(route('staff.profile')); ?>" class="nav-item <?php echo e(request()->routeIs('staff.profile') ? 'active' : ''); ?>">
                <i class="fas fa-user"></i>
                <span>My Profile</span>
            </a>
        <?php endif; ?>

        <a href="#" class="nav-item" onclick="confirmLogout(event, '<?php echo e(route('logout')); ?>')">
            <i class="fas fa-sign-out-alt"></i>
            <span>Logout</span>
        </a>
    </nav>
</div>

<div class="sidebar-overlay" id="sidebarOverlay"></div>
<?php /**PATH C:\wamp64\www\edu-p\resources\views/components/sidebar.blade.php ENDPATH**/ ?>